package com.openexchange.office.calcengine.client.impl.jms;

import org.apache.commons.lang.StringUtils;

public enum ECalcEngineResult
{
    //-------------------------------------------------------------------------
	E_OK,
	E_ERROR,
	E_TIMEOUT;
	
    //-------------------------------------------------------------------------
	public static final String RESULTSTR_OK      = "ok"     ;
	public static final String RESULTSTR_ERROR   = "error"  ;
	public static final String RESULTSTR_TIMEOUT = "timeout";

    //-------------------------------------------------------------------------
	public static ECalcEngineResult fromString (final String sResult)
	    throws Exception
	{
		ECalcEngineResult eResult = null;

		if (StringUtils.equalsIgnoreCase(sResult, RESULTSTR_OK))
			eResult = E_OK;
		else
		if (StringUtils.equalsIgnoreCase(sResult, RESULTSTR_ERROR))
			eResult = E_ERROR;
		else
		if (StringUtils.equalsIgnoreCase(sResult, RESULTSTR_TIMEOUT))
			eResult = E_TIMEOUT;
		else
			throw new UnsupportedOperationException ("no support for '"+sResult+"' implemented yet");

		return eResult;
	}

    //-------------------------------------------------------------------------
	public static String toString (final ECalcEngineResult eResult)
	    throws Exception
	{
		String sResult = null;
		
		if (eResult == E_OK)
			sResult = RESULTSTR_OK;
		else
		if (eResult == E_ERROR)
			sResult = RESULTSTR_ERROR;
		else
		if (eResult == E_TIMEOUT)
			sResult = RESULTSTR_TIMEOUT;
		else
			throw new UnsupportedOperationException ("no support for '"+eResult+"' implemented yet");
		
		return sResult;
	}
}
