package com.openexchange.office.calcengine.client.impl.jms;

import javax.jms.Message;


public class CalcEngineJMSMessage
{
    //-------------------------------------------------------------------------
	public static final String HEADER_PROP_PREFIX = "calcengine-jms-message.header";

	//-------------------------------------------------------------------------
	public static final String HEADER_PROP_DOC_HANDLE = HEADER_PROP_PREFIX+".doc-handle";

    //-------------------------------------------------------------------------
	protected CalcEngineJMSMessage ()
	{}
	
	//-------------------------------------------------------------------------
	protected void fromJMSMessage (final Message aMessage)
	    throws Exception
	{
		final String sDocHandle = aMessage.getStringProperty(HEADER_PROP_DOC_HANDLE);
		setDocHandle(sDocHandle);
	}

	//-------------------------------------------------------------------------
	protected void toJMSMessage (final Message aMessage)
	    throws Exception
	{
		final String sDocHandle = getDocHandle();
		aMessage.setStringProperty(HEADER_PROP_DOC_HANDLE, sDocHandle);
	}

	//-------------------------------------------------------------------------
	public void setDocHandle (final String sHandle)
	    throws Exception
	{
		m_sDocHandle = sHandle;
	}
	
	//-------------------------------------------------------------------------
	public String getDocHandle ()
	    throws Exception
	{
		return m_sDocHandle;
	}

	//-------------------------------------------------------------------------
	private String m_sDocHandle = null;
}
