/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the Open-Xchange, Inc. group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2004-2012 Open-Xchange, Inc.
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */
package com.openexchange.office.tools.jobpool;


//=============================================================================
public class JobResults extends MapImpl
{
	//-------------------------------------------------------------------------
	private static final long serialVersionUID = 1L;

	//-------------------------------------------------------------------------
	/** [Boolean]
	 *  TRUE  if job execution was successfully;
	 *  FALSE otherwise.
	 */
	public static final String PROP_WAS_SUCCESSFULLY = "was.successfully";
	
	//-------------------------------------------------------------------------
	/** [Boolean]
	 *  TRUE if job execution timed out with no result ...
	 *  FALSE if it was successfully (regarding pure execution - not related to the job result itself!)
	 */
	public static final String PROP_WAS_TIMEOUT = "was.timeout";

	//-------------------------------------------------------------------------
	/** [Throwable]
	 *  contain the last exception catched anywhere else inside job workflow ...
	 */
	public static final String PROP_EXCEPTION = "exception";

	//-------------------------------------------------------------------------
	public JobResults()
		throws Exception
	{
		super();
	}

	//-------------------------------------------------------------------------
	/** @return true if job execution was successfully; false otherwise. 
	 * 
	 *  @note	If results isn't well known ... FALSE will be returned by default !
	 */
	public synchronized boolean wasSuccessfully ()
	    throws Exception
	{
		final Boolean bSuccess = get (PROP_WAS_SUCCESSFULLY, Boolean.FALSE);
		return bSuccess;
	}

	//-------------------------------------------------------------------------
	/** @return true if job timed out; false otherwise. 
	 * 
	 *  @note	If results isn't well known ... FALSE will be returned by default !
	 */
	public synchronized boolean wasTimeout ()
	    throws Exception
	{
		final Boolean bTimeout = get (PROP_WAS_TIMEOUT, Boolean.FALSE);
		return bTimeout;
	}

	//-------------------------------------------------------------------------
	public void setSuccessfully ()
	    throws Exception
	{
		set (PROP_WAS_SUCCESSFULLY, Boolean.TRUE);
	}

	//-------------------------------------------------------------------------
	public void setError ()
	    throws Exception
	{
		set (PROP_WAS_SUCCESSFULLY, Boolean.FALSE);
	}

	//-------------------------------------------------------------------------
	public void setError (Throwable ex)
	    throws Exception
	{
		set (PROP_WAS_SUCCESSFULLY, Boolean.FALSE);
		set (PROP_EXCEPTION       , ex           );
	}

	//-------------------------------------------------------------------------
	public void setTimeout ()
	    throws Exception
	{
		set (PROP_WAS_SUCCESSFULLY, Boolean.FALSE);
		set (PROP_WAS_TIMEOUT     , Boolean.TRUE );
	}

	//-------------------------------------------------------------------------
	public static final synchronized JobResults EMPTY_RESULT ()
		throws Exception
	{
		return new JobResults ();
	}

	//-------------------------------------------------------------------------
	public static final synchronized JobResults OK_RESULT ()
		throws Exception
	{
		JobResults lResults = new JobResults ();
		lResults.setSuccessfully();
		return lResults;
	}

	//-------------------------------------------------------------------------
	public static final synchronized JobResults ERROR_RESULT (final Throwable ex)
		throws Exception
	{
		JobResults lResults = new JobResults ();
		lResults.setError (ex);
		return lResults;
	}

	//-------------------------------------------------------------------------
	public static final synchronized JobResults TIMEOUT_RESULT ()
		throws Exception
	{
		JobResults lResults = new JobResults ();
		lResults.setTimeout();
		return lResults;
	}
}
