/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the Open-Xchange, Inc. group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2004-2012 Open-Xchange, Inc.
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */
package com.openexchange.office.tools.jobpool;


//=============================================================================
public abstract class JobBase
{
	//-------------------------------------------------------------------------
	protected JobBase ()
	   throws Exception
	{}

	//-------------------------------------------------------------------------
	public synchronized void activateJob ()
	    throws Exception
	{
		System.out.println ("activate job ["+getId ()+"]");
		try
		{
			activateImpl (mem_Environment ());
		}
		catch (Exception ex)
		{
			System.err.println (ex.getMessage ());
			ex.printStackTrace(System.err);
			throw ex;
		}
	}
	
	//-------------------------------------------------------------------------
	public synchronized void deactivateJob ()
	    throws Exception
	{
		System.out.println ("dectivate job ["+getId ()+"]");
		try
		{
			deactivateImpl (mem_Environment ());
		}
		catch (Exception ex)
		{
			System.err.println (ex.getMessage ());
			ex.printStackTrace(System.err);
			throw ex;
		}
	}

	//-------------------------------------------------------------------------
	public synchronized void validateJob ()
	    throws Exception
	{
		System.out.println ("validate job ["+getId ()+"]");
		try
		{
			validateImpl (mem_Environment ());
		}
		catch (Exception ex)
		{
			System.err.println (ex.getMessage ());
			ex.printStackTrace(System.err);
			throw ex;
		}
	}

	//-------------------------------------------------------------------------
	public synchronized void setEnvironment(final JobEnvironment aEnv)
		throws Exception
	{
		m_aEnv = aEnv;
	}

	//-------------------------------------------------------------------------
	public synchronized int getId ()
		throws Exception
	{
		return m_aEnv.getId();
	}

	//-------------------------------------------------------------------------
	public synchronized void setArguments(final JobArguments iArguments)
		throws Exception
	{
		m_lArguments = iArguments;
	}

	//-------------------------------------------------------------------------
	public synchronized JobResults getResults()
		throws Exception
	{
		return mem_Results ();
	}

	//-------------------------------------------------------------------------
	public /*NO SYNCHRONIZE !*/ void execute()
		throws Exception
	{
		synchronized(this) // ???
		{
			executeImpl (mem_Environment (),
						 mem_Arguments   (),
						 mem_Results     ());
		}
	}

	//-------------------------------------------------------------------------
	protected abstract void activateImpl (final JobEnvironment aEnv)
	    throws Exception;
	
	//-------------------------------------------------------------------------
	protected abstract void validateImpl (final JobEnvironment aEnv)
	    throws Exception;

	//-------------------------------------------------------------------------
	protected abstract void executeImpl (final JobEnvironment aEnv      ,
										 final JobArguments   lArguments,
										 final JobResults     lResults  )
	    throws Exception;

	//-------------------------------------------------------------------------
	protected abstract void deactivateImpl (final JobEnvironment aEnv)
	    throws Exception;

	//-------------------------------------------------------------------------
	private JobEnvironment mem_Environment ()
	    throws Exception
	{
		if (m_aEnv == null)
			m_aEnv = JobEnvironment.EMPTY_ENVIRONMENT();
		return m_aEnv;
	}

	//-------------------------------------------------------------------------
	private JobArguments mem_Arguments ()
	    throws Exception
	{
		if (m_lArguments == null)
			m_lArguments = JobArguments.EMPTY_ARGUMENTS();
		return m_lArguments;
	}
	
	//-------------------------------------------------------------------------
	private JobResults mem_Results ()
	    throws Exception
	{
		if (m_lResults == null)
			m_lResults = JobResults.EMPTY_RESULT();
		return m_lResults;
	}

	//-------------------------------------------------------------------------
	private JobEnvironment m_aEnv = null;

	//-------------------------------------------------------------------------
	private JobArguments m_lArguments = null;
	
	//-------------------------------------------------------------------------
	private JobResults m_lResults = null;
}
