package com.openexchange.office.tools.executablewrapper;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

import org.apache.commons.lang.StringUtils;

//==============================================================================
public class ExecutableWatch
{
    //--------------------------------------------------------------------------
	public ExecutableWatch ()
	    throws Exception
	{}

	//--------------------------------------------------------------------------
	public synchronized void addWatcher (final IExecutableWatcher iWatcher)
	    throws Exception
	{
		final Map< String, IExecutableWatcher > aRegistry = mem_Registry ();
		final String[]                          lWatches  = iWatcher.getWatchPoints();
		
		if (lWatches == null)
			return;
		
		for (String sWatch : lWatches)
			aRegistry.put(sWatch, iWatcher);
	}
	
	//--------------------------------------------------------------------------
	public synchronized void scanForWatches (final String sContent)
	    throws Exception
	{
		StringBuffer aBuffer = mem_Buffer ();
		aBuffer.append (sContent);
		
		final String                            sCheck    = aBuffer.toString ();
		final Map< String, IExecutableWatcher > aRegistry = mem_Registry ();
		final Iterator< String >                pWatches  = aRegistry.keySet().iterator();
		
		while (pWatches.hasNext())
		{
			final String sWatch = pWatches.next();

			if (! StringUtils.contains(sCheck, sWatch))
				continue;
			
			final IExecutableWatcher iWatcher = aRegistry.get(sWatch);
			
			if (iWatcher == null)
				break;
			
			aRegistry.remove(sWatch);
			try
			{
				iWatcher.watchPointDetected(sWatch);
			}
			catch (Exception ex)
			{}
			
			break;
		}
	}
	
	//--------------------------------------------------------------------------
	private Map< String, IExecutableWatcher > mem_Registry ()
		throws Exception
	{
		if (m_lRegistry == null)
			m_lRegistry = new HashMap< String, IExecutableWatcher >();
		return m_lRegistry;
	}

	//--------------------------------------------------------------------------
	private StringBuffer mem_Buffer ()
	    throws Exception
	{
		if (m_aBuffer == null)
			m_aBuffer = new StringBuffer (4096);
		return m_aBuffer;
	}
	
	//--------------------------------------------------------------------------
	private Map< String, IExecutableWatcher > m_lRegistry = null;

	//--------------------------------------------------------------------------
	private StringBuffer m_aBuffer = null;
}
