/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the Open-Xchange, Inc. group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2004-2012 Open-Xchange, Inc.
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */
package com.openexchange.office.calcengine;

import org.json.JSONException;
import org.json.JSONObject;

/**
 * {@link JCalcDocument}
 *
 * @author <a href="mailto:oliver.specht@open-xchange.com">Oliver Specht</a>
 */
public class JCalcDocument{

    public static final long INVALID_HANDLE = -1;
    public static final String ATTR_HANDLE = "handle";
    
	private long handle = INVALID_HANDLE;

    //-------------------------------------------------------------------------
	public JCalcDocument(){
	}
	
    //-------------------------------------------------------------------------
    public JCalcDocument(long _handle){
        setHandle(_handle);
    }

    //-------------------------------------------------------------------------
	public long getHandle(){
		return handle;
	}
	
    //-------------------------------------------------------------------------
	public void setHandle(long _handle){
		handle = _handle;
	}
	
	//-------------------------------------------------------------------------
	/** @return the corresponding document handle of the given JSON expression.
	 * 
	 *  @note return an invalid handle in case json expression couldnt be parsed successfully. 
	 * 
	 *  @param json [IN] the json expression to be parsed here.
	 */
	public static JCalcDocument fromJSON (JSONObject json) {
        JCalcDocument doc = new JCalcDocument ();
	    try{
	        doc.handle = json.getLong(ATTR_HANDLE);
	    } catch (JSONException ex){
	        doc.handle = INVALID_HANDLE;
	    }
	    return doc;
	}

    //-------------------------------------------------------------------------
    public static JCalcDocument fromJSON (String json) {
        JCalcDocument doc = new JCalcDocument ();
        try{
            JSONObject parser = new JSONObject(json);
            doc.handle = parser.getLong(ATTR_HANDLE);
        } catch (JSONException ex){
            doc.handle = INVALID_HANDLE;
        }
        return doc;
    }

    //-------------------------------------------------------------------------
	/** @return the JSON expression of the given document handle.
	 * 
     *  @note return NULL in case json expression couldnt be created successfully.
     *  
	 *  @param doc [IN] the document handle.
	 */
    public static String toJSON (JCalcDocument doc) {
        String jsonString = null;
        try{
            JSONObject json = new JSONObject();
            json.put(ATTR_HANDLE, doc.handle);
            jsonString = json.toString();
        } catch (JSONException ex){
            jsonString = null; // ???
        }
        return jsonString;
    }
}
