/*
 *
1 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the Open-Xchange, Inc. group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2004-2012 Open-Xchange, Inc.
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package com.openexchange.office.osgi;

import org.apache.commons.logging.Log;
import com.openexchange.config.ConfigurationService;
import com.openexchange.filemanagement.DistributedFileManagement;
import com.openexchange.filemanagement.ManagedFileManagement;
import com.openexchange.log.LogFactory;
import com.openexchange.office.IResourceProvider;
import com.openexchange.office.resource.ResourceProvider;
import com.openexchange.osgi.HousekeepingActivator;

//-------------------
//- class Activator -
//-------------------

/**
 * {@link OXOServerActivator}
 * 
 * @author <a href="mailto:kai.ahrens@open-xchange.com">Kai Ahrens</a>
 */
public class OfficeActivator extends HousekeepingActivator {

    @Override
    protected Class<?>[] getNeededServices() {
        return new Class<?>[] { ConfigurationService.class, ManagedFileManagement.class, DistributedFileManagement.class };
    }

    @Override
    protected void startBundle() throws Exception {

        final Log log = com.openexchange.log.Log.valueOf(LogFactory.getLog(OfficeActivator.class));

        log.info("Starting Operation bundle: com.openexchange.office");
        try {
            log.info("Starting OOXML filter: com.openexchange.office");
            // register docx4j im- and exporter
            final com.openexchange.office.ooxml.docx.Importer docxImporter = new com.openexchange.office.ooxml.docx.Importer(this);
            registerService(com.openexchange.office.ooxml.docx.Importer.class, docxImporter);

            final com.openexchange.office.ooxml.docx.Exporter docxExporter = new com.openexchange.office.ooxml.docx.Exporter(this);
            registerService(com.openexchange.office.ooxml.docx.Exporter.class, docxExporter);

            final com.openexchange.office.ooxml.pptx.Importer pptxImporter = new com.openexchange.office.ooxml.pptx.Importer(this);
            registerService(com.openexchange.office.ooxml.pptx.Importer.class, pptxImporter);

            final com.openexchange.office.ooxml.pptx.Exporter pptxExporter = new com.openexchange.office.ooxml.pptx.Exporter(this);
            registerService(com.openexchange.office.ooxml.pptx.Exporter.class, pptxExporter);

            final com.openexchange.office.ooxml.xlsx.Importer xlsxImporter = new com.openexchange.office.ooxml.xlsx.Importer(this);
            registerService(com.openexchange.office.ooxml.xlsx.Importer.class, xlsxImporter);

            final com.openexchange.office.ooxml.xlsx.Exporter xlsxExporter = new com.openexchange.office.ooxml.xlsx.Exporter(this);
            registerService(com.openexchange.office.ooxml.xlsx.Exporter.class, xlsxExporter);
        } catch (Throwable e) {
            log.info("FAILED - Starting OOXML filter: com.openexchange.office" + e);
            log.fatal("Office bundle was not completly loaded", e);
            throw new Exception(e);
        }
        try {            
            log.info("Starting ODF filter: com.openexchange.office");
            // register ODFDOM im- and exporter
            final com.openexchange.office.odf.Importer odfImporter = new com.openexchange.office.odf.Importer(this);
            registerService(com.openexchange.office.odf.Importer.class, odfImporter);

            final com.openexchange.office.odf.Exporter odfExporter = new com.openexchange.office.odf.Exporter(this);
            registerService(com.openexchange.office.odf.Exporter.class, odfExporter);
        } catch (Throwable e) {
            log.info("FAILED - Starting ODF filter: com.openexchange.office" + e);
            log.fatal("Office bundle was not completly loaded", e);
            throw new Exception(e);
        }
        try {            
        
            log.info("Starting Resource Provider: com.openexchange.office");            
            // register resource provider
            final ResourceProvider resourceProvider = new ResourceProvider();
            registerService(IResourceProvider.class, resourceProvider);
        } catch (Throwable e) {
            log.info("FAILED - Starting Resource Provider: com.openexchange.office" + e);
            log.fatal("Office bundle was not completly loaded", e);
            throw new Exception(e);
        }
        try {            

            log.info("Starting Calc Engine Provider: com.openexchange.office");                        
            // register factory for instances of type ICalcEngineClient
            final com.openexchange.office.calcengine.client.CalcEngineClientFactory calcEngineFactory = new com.openexchange.office.calcengine.client.CalcEngineClientFactory(
                this);
            registerService(com.openexchange.office.calcengine.client.CalcEngineClientFactory.class, calcEngineFactory);
        } catch (Throwable e) {
            log.info("FAILED - Starting Calc Engine Provider: com.openexchange.office" + e);
            log.fatal("Office bundle was not completly loaded", e);
            throw new Exception(e);
        }

    }
}
