/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the Open-Xchange, Inc. group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2004-2012 Open-Xchange, Inc.
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package com.openexchange.office.ooxml.tools;

import java.util.List;
import javax.xml.bind.JAXBElement;
import org.docx4j.dml.CTColor;
import org.json.JSONException;
import org.json.JSONObject;


final public class Commons {
    private Commons() {}

    public static  String ctColorToString( CTColor color ){
        final String fillString = "000000";
        byte[] rgbVal = color.getSrgbClr() != null ? color.getSrgbClr().getVal() : color.getSysClr().getLastClr();
        String ret = Integer.toHexString((((rgbVal[0]& 0xFF)<< 16) + ((rgbVal[1]& 0xFF)<< 8) + (rgbVal[2]& 0xFF)));
        if( ret.length() < 6 )
            ret = fillString.substring( ret.length() ) + ret;
        return ret;
    }

    public static JAXBElement<?> findElement(List<JAXBElement<?>> jaxbElements, String elementName) {
        for (int i=0; i<jaxbElements.size(); i++) {
            if (elementName.equals(jaxbElements.get(i).getName().getLocalPart())) {
                return jaxbElements.get(i);
            }
        }
        return null;
    }

    public static void removeElement(List<JAXBElement<?>> jaxbElements, String elementName) {
        for(int i=0; i<jaxbElements.size(); i++) {
            if(elementName.equals(jaxbElements.get(i).getName().getLocalPart())) {
                jaxbElements.remove(i);
            }
        }
    }

    public static void insertElement(List<JAXBElement<?>> jaxbElements, String elementName, JAXBElement<?> jaxbInsert) {
        JAXBElement<?> jaxb = findElement(jaxbElements, elementName);
        if(jaxb!=null)
            jaxb = jaxbInsert;
        else
            jaxbElements.add(jaxbInsert);
    }

    public static JSONObject surroundJSONObject(String type, JSONObject source) {
        if(source==null||source.length()==0)
            return null;
        JSONObject newJSON = new JSONObject();
        try {
            newJSON.put(type,  source);
        } catch (JSONException e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
        }
        return newJSON;
    }
}
