/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the Open-Xchange, Inc. group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2004-2012 Open-Xchange, Inc.
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package com.openexchange.office.ooxml.xlsx.operations;

import java.util.List;
import javax.xml.bind.JAXBException;
import org.docx4j.openpackaging.exceptions.InvalidFormatException;
import org.docx4j.openpackaging.packages.SpreadsheetMLPackage;
import org.docx4j.openpackaging.parts.PartName;
import org.docx4j.openpackaging.parts.SpreadsheetML.WorkbookPart;
import org.docx4j.openpackaging.parts.relationships.RelationshipsPart;
import org.docx4j.relationships.Relationship;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.xlsx4j.sml.Sheet;
import org.xlsx4j.sml.Sheets;
import org.xlsx4j.sml.Workbook;
import com.openexchange.office.ooxml.xlsx.OperationDocument;
import com.openexchange.office.ooxml.xlsx.tools.SheetUtils;

public class ApplyOperationHelper extends com.openexchange.office.ooxml.operations.ApplyOperationHelper {

    private final OperationDocument operationDocument;
    private final SpreadsheetMLPackage spreadsheetMLPackage;
    private final WorkbookPart workbookPart;

    public ApplyOperationHelper(OperationDocument _operationDocument) {
        super();

        operationDocument = _operationDocument;
        spreadsheetMLPackage = _operationDocument.getPackage();
        workbookPart = spreadsheetMLPackage.getWorkbookPart();
    }

    @Override
    public OperationDocument getOperationDocument() {
        return operationDocument;
    }

    public void setCellContents(int sheetIndex, JSONArray start, JSONArray contents, String parse) {

    }

    // TODO sheet attrs have to be applied

    public void insertSheet(int sheetIndex, String sheetName, JSONObject attrs)
        throws InvalidFormatException, JAXBException, JSONException {

        // first we have to get a free relationship that can be used for our new sheet
        int sheetNumber = 1;

        Relationship relShip = null;
        PartName partName = null;
        do {
            partName = new PartName("/xl/worksheets/sheet" + Integer.toString(sheetNumber++) + ".xml");
            relShip = workbookPart.getRelationshipsPart().getRel(partName);
        }
        while(relShip!=null);

        // now we have a free partName... and we will look for a free SheetId
        Workbook workbook = workbookPart.getJaxbElement();
        Sheets sheets = workbook.getSheets();
        List<Sheet> sheetList = sheets.getSheet();

        long sheetId = 1;
        do {
            boolean idFound = false;
            for(int i = 0; i < sheetList.size(); i++) {
                if(sheetList.get(i).getSheetId()==sheetId) {
                    idFound = true;
                    break;
                }
            }
            if(idFound==false)
                break;
            sheetId++;
        }
        while(true);
        spreadsheetMLPackage.createWorksheetPart(partName, sheetName, sheetId);

        // setting the correct index position
        Sheet sheet = sheetList.remove(sheetList.size() - 1);
        sheetList.add(sheetIndex, sheet);
        if(attrs!=null)
            SheetUtils.applySheetProperties(workbook.getSheets().getSheet().get(sheetIndex), attrs.optJSONObject("sheet"));
    }

    public void moveSheet(int sheetIndex, int to) {
        Workbook workbook = workbookPart.getJaxbElement();
        Sheets sheets = workbook.getSheets();
        List<Sheet> sheetList = sheets.getSheet();
        sheetList.add(to, sheetList.remove(sheetIndex));
    }

    public void deleteSheet(int sheetIndex) {
        Workbook workbook = workbookPart.getJaxbElement();
        Sheets sheets = workbook.getSheets();
        List<Sheet> sheetList = sheets.getSheet();
        Sheet sheet = sheetList.remove(sheetIndex);
        String relId = sheet.getId();
        RelationshipsPart relationshipsPart = workbookPart.getRelationshipsPart();
        relationshipsPart.removeRelationship(relationshipsPart.getRelationshipByID(relId));
    }

    public void setSheetName(int sheetIndex, String sheetName) {
        Workbook workbook = workbookPart.getJaxbElement();
        workbook.getSheets().getSheet().get(sheetIndex).setName(sheetName);
    }

    public void setSheetAttributes(int sheetIndex, JSONObject attrs)
        throws JSONException {

        Workbook workbook = workbookPart.getJaxbElement();
        if(attrs!=null)
            SheetUtils.applySheetProperties(workbook.getSheets().getSheet().get(sheetIndex), attrs.optJSONObject("sheet"));
    }
}
