package com.openexchange.office.json.actions;


public enum ErrorCode {
    
    NO_ERROR(0, "No error"),
    FILTER_NOBACKUP_ERROR(100, "The document is inconsistent and no backup file could be created!"),
    FILTER_OPERATION_ERROR(101, "The document is inconsistent and is saved as doc_ox file!");

    private final int m_code;
    private final String m_description;

    private ErrorCode(int code, String description) {
      this.m_code = code;
      this.m_description = description;
    }

    public String getDescription() {
       return m_description;
    }

    public int getCode() {
       return m_code;
    }

    @Override
    public String toString() {
      return m_code + ": " + m_description;
    }
}
