/*
 * Decompiled with CFR 0.152.
 */
package org.json.helpers.misc;

public class FpUtils {
    static double twoToTheDoubleScaleUp = FpUtils.powerOfTwoD(512);
    static double twoToTheDoubleScaleDown = FpUtils.powerOfTwoD(-512);

    private FpUtils() {
    }

    public static int getExponent(double d) {
        return (int)(((Double.doubleToRawLongBits(d) & 0x7FF0000000000000L) >> 52) - 1023L);
    }

    public static int getExponent(float f) {
        return ((Float.floatToRawIntBits(f) & 0x7F800000) >> 23) - 127;
    }

    static double powerOfTwoD(int n) {
        assert (n >= -1022 && n <= 1023);
        return Double.longBitsToDouble((long)n + 1023L << 52 & 0x7FF0000000000000L);
    }

    static float powerOfTwoF(int n) {
        assert (n >= -126 && n <= 127);
        return Float.intBitsToFloat(n + 127 << 23 & 0x7F800000);
    }

    public static double rawCopySign(double magnitude, double sign) {
        return Double.longBitsToDouble(Double.doubleToRawLongBits(sign) & Long.MIN_VALUE | Double.doubleToRawLongBits(magnitude) & Long.MAX_VALUE);
    }

    public static float rawCopySign(float magnitude, float sign) {
        return Float.intBitsToFloat(Float.floatToRawIntBits(sign) & Integer.MIN_VALUE | Float.floatToRawIntBits(magnitude) & Integer.MAX_VALUE);
    }

    public static boolean isFinite(double d) {
        return Math.abs(d) <= Double.MAX_VALUE;
    }

    public static boolean isFinite(float f) {
        return Math.abs(f) <= Float.MAX_VALUE;
    }

    public static boolean isInfinite(double d) {
        return Double.isInfinite(d);
    }

    public static boolean isInfinite(float f) {
        return Float.isInfinite(f);
    }

    public static boolean isNaN(double d) {
        return Double.isNaN(d);
    }

    public static boolean isNaN(float f) {
        return Float.isNaN(f);
    }

    public static boolean isUnordered(double arg1, double arg2) {
        return FpUtils.isNaN(arg1) || FpUtils.isNaN(arg2);
    }

    public static boolean isUnordered(float arg1, float arg2) {
        return FpUtils.isNaN(arg1) || FpUtils.isNaN(arg2);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static int ilogb(double d) {
        int exponent = FpUtils.getExponent(d);
        switch (exponent) {
            case 1024: {
                if (!FpUtils.isNaN(d)) return 0x10000000;
                return 0x40000000;
            }
            case -1023: {
                if (d == 0.0) {
                    return -268435456;
                }
                long transducer = Double.doubleToRawLongBits(d);
                assert ((transducer &= 0xFFFFFFFFFFFFFL) != 0L);
                while (true) {
                    if (transducer >= 0x10000000000000L) {
                        assert (++exponent >= -1074 && exponent < -1022);
                        return exponent;
                    }
                    transducer *= 2L;
                    --exponent;
                }
            }
        }
        assert (exponent >= -1022 && exponent <= 1023);
        return exponent;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static int ilogb(float f) {
        int exponent = FpUtils.getExponent(f);
        switch (exponent) {
            case 128: {
                if (!FpUtils.isNaN(f)) return 0x10000000;
                return 0x40000000;
            }
            case -127: {
                if (f == 0.0f) {
                    return -268435456;
                }
                int transducer = Float.floatToRawIntBits(f);
                assert ((transducer &= 0x7FFFFF) != 0);
                while (true) {
                    if (transducer >= 0x800000) {
                        assert (++exponent >= -149 && exponent < -126);
                        return exponent;
                    }
                    transducer *= 2;
                    --exponent;
                }
            }
        }
        assert (exponent >= -126 && exponent <= 127);
        return exponent;
    }

    public static double scalb(double d, int scale_factor) {
        int MAX_SCALE = 2099;
        int exp_adjust = 0;
        int scale_increment = 0;
        double exp_delta = Double.NaN;
        if (scale_factor < 0) {
            scale_factor = Math.max(scale_factor, -2099);
            scale_increment = -512;
            exp_delta = twoToTheDoubleScaleDown;
        } else {
            scale_factor = Math.min(scale_factor, 2099);
            scale_increment = 512;
            exp_delta = twoToTheDoubleScaleUp;
        }
        int t = scale_factor >> 8 >>> 23;
        exp_adjust = (scale_factor + t & 0x1FF) - t;
        d *= FpUtils.powerOfTwoD(exp_adjust);
        scale_factor -= exp_adjust;
        while (scale_factor != 0) {
            d *= exp_delta;
            scale_factor -= scale_increment;
        }
        return d;
    }

    public static float scalb(float f, int scale_factor) {
        int MAX_SCALE = 278;
        scale_factor = Math.max(Math.min(scale_factor, 278), -278);
        return (float)((double)f * FpUtils.powerOfTwoD(scale_factor));
    }

    public static double nextAfter(double start, double direction) {
        if (FpUtils.isNaN(start) || FpUtils.isNaN(direction)) {
            return start + direction;
        }
        if (start == direction) {
            return direction;
        }
        long transducer = Double.doubleToRawLongBits(start + 0.0);
        if (direction > start) {
            transducer += transducer >= 0L ? 1L : -1L;
        } else {
            assert (direction < start);
            transducer = transducer > 0L ? --transducer : (transducer < 0L ? ++transducer : -9223372036854775807L);
        }
        return Double.longBitsToDouble(transducer);
    }

    public static float nextAfter(float start, double direction) {
        if (FpUtils.isNaN(start) || FpUtils.isNaN(direction)) {
            return start + (float)direction;
        }
        if ((double)start == direction) {
            return (float)direction;
        }
        int transducer = Float.floatToRawIntBits(start + 0.0f);
        if (direction > (double)start) {
            transducer += transducer >= 0 ? 1 : -1;
        } else {
            assert (direction < (double)start);
            transducer = transducer > 0 ? --transducer : (transducer < 0 ? ++transducer : -2147483647);
        }
        return Float.intBitsToFloat(transducer);
    }

    public static double nextUp(double d) {
        if (FpUtils.isNaN(d) || d == Double.POSITIVE_INFINITY) {
            return d;
        }
        return Double.longBitsToDouble(Double.doubleToRawLongBits(d += 0.0) + (d >= 0.0 ? 1L : -1L));
    }

    public static float nextUp(float f) {
        if (FpUtils.isNaN(f) || f == Float.POSITIVE_INFINITY) {
            return f;
        }
        return Float.intBitsToFloat(Float.floatToRawIntBits(f += 0.0f) + (f >= 0.0f ? 1 : -1));
    }

    public static double nextDown(double d) {
        if (FpUtils.isNaN(d) || d == Double.NEGATIVE_INFINITY) {
            return d;
        }
        if (d == 0.0) {
            return -4.9E-324;
        }
        return Double.longBitsToDouble(Double.doubleToRawLongBits(d) + (d > 0.0 ? -1L : 1L));
    }

    public static double nextDown(float f) {
        if (FpUtils.isNaN(f) || f == Float.NEGATIVE_INFINITY) {
            return f;
        }
        if (f == 0.0f) {
            return -1.4E-45f;
        }
        return Float.intBitsToFloat(Float.floatToRawIntBits(f) + (f > 0.0f ? -1 : 1));
    }

    public static double copySign(double magnitude, double sign) {
        return FpUtils.rawCopySign(magnitude, FpUtils.isNaN(sign) ? 1.0 : sign);
    }

    public static float copySign(float magnitude, float sign) {
        return FpUtils.rawCopySign(magnitude, FpUtils.isNaN(sign) ? 1.0f : sign);
    }

    public static double ulp(double d) {
        int exp = FpUtils.getExponent(d);
        switch (exp) {
            case 1024: {
                return Math.abs(d);
            }
            case -1023: {
                return Double.MIN_VALUE;
            }
        }
        assert (exp <= 1023 && exp >= -1022);
        if ((exp -= 52) >= -1022) {
            return FpUtils.powerOfTwoD(exp);
        }
        return Double.longBitsToDouble(1L << exp - -1074);
    }

    public static float ulp(float f) {
        int exp = FpUtils.getExponent(f);
        switch (exp) {
            case 128: {
                return Math.abs(f);
            }
            case -127: {
                return Float.MIN_VALUE;
            }
        }
        assert (exp <= 127 && exp >= -126);
        if ((exp -= 23) >= -126) {
            return FpUtils.powerOfTwoF(exp);
        }
        return Float.intBitsToFloat(1 << exp - -149);
    }

    public static double signum(double d) {
        return d == 0.0 || FpUtils.isNaN(d) ? d : FpUtils.copySign(1.0, d);
    }

    public static float signum(float f) {
        return f == 0.0f || FpUtils.isNaN(f) ? f : FpUtils.copySign(1.0f, f);
    }
}

