package org.xlsx4j.samples;

import org.docx4j.jaxb.Context;
import org.docx4j.openpackaging.io.SaveToZipFile;
import org.docx4j.openpackaging.packages.SpreadsheetMLPackage;
import org.docx4j.openpackaging.parts.PartName;
import org.docx4j.openpackaging.parts.SpreadsheetML.WorksheetPart;
import org.xlsx4j.sml.Cell;
import org.xlsx4j.sml.Row;
import org.xlsx4j.sml.SheetData;

public class CreateSimpleSpreadsheet {

	public static void main(String[] args) throws Exception {

		String outputfilepath = System.getProperty("user.dir") + "/sample-docs/xlsx/test-out.xlsx";

		SpreadsheetMLPackage pkg = SpreadsheetMLPackage.createPackage();

		WorksheetPart sheet = pkg.createWorksheetPart(new PartName("/xl/worksheets/sheet1.xml"), "Sheet1", 1);

		addContent(sheet);

		SaveToZipFile saver = new SaveToZipFile(pkg);
		saver.save(outputfilepath);

		System.out.println("\n\n done .. " + outputfilepath);
	}

	private static void addContent(WorksheetPart sheet) {

		// Minimal content already present
		SheetData sheetData = sheet.getJaxbElement().getSheetData();

		// Now add
		Row row = Context.getsmlObjectFactory().createRow();
		Cell cell = Context.getsmlObjectFactory().createCell();
		cell.setV("1234");

		// Note: if you are trying to add characters, not a number,
		// the easiest approach is to use inline strings (as opposed to the shared string table).
		// See http://openxmldeveloper.org/blog/b/openxmldeveloper/archive/2011/11/22/screen-cast-write-simpler-spreadsheetml-when-generating-spreadsheets.aspx
		// and http://www.docx4java.org/forums/xlsx-java-f15/cells-with-character-values-t874.html

		row.getC().add(cell);
		sheetData.getRow().add(row);
	}

}
