/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the Open-Xchange, Inc. group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2004-2012 Open-Xchange, Inc.
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */
package com.openexchange.office.calcengine.server;

import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.Validate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONObject;
import com.openexchange.office.calcengine.CalcEngineNativeWrapper;
import com.openexchange.office.calcengine.CalcEngineConst;
import com.openexchange.office.calcengine.JCalcDocument;
import com.openexchange.office.calcengine.JOperation;

//=============================================================================
/** bind the calc engine JNI code to REST.
*/
@Path(CalcEngineConst.CALCENGINE_SERVLETPATH)
//@Consumes(MediaType.APPLICATION_JSON)
//@Produces(MediaType.APPLICATION_JSON)
public class CalcEngineServer
{
    //-------------------------------------------------------------------------
    private static final Log LOG = LogFactory.getLog(CalcEngineServer.class);

    //-------------------------------------------------------------------------
    public CalcEngineServer ()
    {}
    
    //-------------------------------------------------------------------------
    @GET
    public Response createDocument()
        throws Exception
    {
        try
        {
            JCalcDocument aDoc      = mem_Impl().createDocument();
            String        sJSON     = JCalcDocument.toJSON(aDoc);
            Response      aResponse = Response.ok (sJSON, MediaType.APPLICATION_JSON).build();
            return aResponse;
        }
        catch (Throwable ex)
        {
            LOG.error(ex.getMessage(), ex);
            return Response.serverError().entity(ex.getMessage()).build();
        }
    }

    //-------------------------------------------------------------------------
    @POST
    @Path("{handle}/"+CalcEngineConst.RELPATH_CALCULATE)
    public Response calculate(@PathParam("handle") final String sHandle)
        throws Exception
    {
        JCalcDocument aDoc      = impl_getDocumentFromHandle (sHandle);
        boolean       bState    = mem_Impl ().calculate(aDoc);
        Response      aResponse = null;

        if (bState)
            aResponse = Response.ok().build();
        else
            aResponse = Response.serverError().entity("Unknown document.").build();

        return aResponse;
    }
    
    //-------------------------------------------------------------------------
    @DELETE
    @Path("{handle}")
    public Response destroyDocument(@PathParam("handle") final String sHandle)
        throws Exception
    {
        JCalcDocument aDoc   = impl_getDocumentFromHandle (sHandle);
        boolean       bState = mem_Impl ().destroyDocument(aDoc);
        Response      aResponse = null;

        if (bState)
            aResponse = Response.ok().build();
        else
            aResponse = Response.serverError().entity("Unknown document.").build();

        return aResponse;
    }

    //-------------------------------------------------------------------------
    @POST
    @Path("{handle}/"+CalcEngineConst.RELPATH_EXECUTE)
    public Response executeOperation(@PathParam("handle") final String sHandle,
                                                          final String sOpJSON)
        throws Exception
    {
        JCalcDocument aDoc      = impl_getDocumentFromHandle (sHandle);
        JOperation    aOp       = new JOperation (new JSONObject(sOpJSON));
        boolean       bState    = mem_Impl ().executeOperation(aDoc, aOp);
        Response      aResponse = null;

        if (bState)
        {
            String sJSONResult = aOp.getResult().toString();
            Validate.notEmpty(sJSONResult, "state=true ... but no JSON result available !");
            aResponse = Response.ok().entity(sJSONResult).build();
        }
        else
            aResponse = Response.serverError().entity("Unknown document.").build();

        return aResponse;
    }

    //-------------------------------------------------------------------------
    private JCalcDocument impl_getDocumentFromHandle (String sHandle)
        throws Exception
    {
        long          nHandle = Long.parseLong    (sHandle);
        JCalcDocument aDoc    = new JCalcDocument (nHandle);
        return aDoc;
    }
    
    //-------------------------------------------------------------------------
    private CalcEngineNativeWrapper mem_Impl ()
        throws Exception
    {
        if (m_aImpl == null)
            m_aImpl = new CalcEngineNativeWrapper ();
        return m_aImpl;
    }

    //-------------------------------------------------------------------------
    private CalcEngineNativeWrapper m_aImpl = null;
}
