/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the Open-Xchange, Inc. group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2004-2012 Open-Xchange, Inc.
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */
package com.openexchange.office.calcengine.client;


//=============================================================================
public interface ICalcEngineClient
{
    //-------------------------------------------------------------------------
    /** create a new (empty) calc document and return an unique handle
     *  which can be used as reference to those document for further requests.
     *  
     *  @return the unique handle of that document.
     *  
     *  @throws an exception in case document could not be created successfully.
     */
    public String createDocument ()
        throws Exception;

    //-------------------------------------------------------------------------
    /** close and delete the document referenced by the given handle.
     * 
     *  @param  sHandle [IN]
     *          the unique handle retrieved by any createDocument()
     *          request before.
     *          
     *  Does nothing in case document dose not exists.
     *  Throws an exception in case something goes wrong. 
     */
    public void destroyDocument (final String sHandle)
        throws Exception;

    //-------------------------------------------------------------------------
    /** recalculate the document referenced by the given handle.
     * 
     *  @param  sHandle [IN]
     *          the unique handle retrieved by any createDocument()
     *          request before.
     *  
     *  @throws an exception in case calculation goes wrong.
     */
    public void calculate (final String sHandle)
        throws Exception;

    //-------------------------------------------------------------------------
    /** execute the given operation (formated as JSON) on the referenced document
     *  and return the result as formated JSON too.
     * 
     *  @param  sHandle [IN]
     *          the unique handle retrieved by any createDocument()
     *          request before.
     *  
     *  @param  sOperationJSON [IN]
     *          the (might set of) operation to be executed on the
     *          requested document.
     *
     *  @return the result formated as JSON.
     *
     *  @throws an exception in case execution goes wrong.
     */
    public String executeOperation (final String sHandle       ,
                                    final String sOperationJSON)
        throws Exception;
}
