/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the Open-Xchange, Inc. group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2004-2012 Open-Xchange, Inc.
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */
package com.openexchange.office.calcengine.client;

import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.UriBuilder;
import org.apache.commons.lang.Validate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import com.openexchange.office.calcengine.CalcEngineConst;
import com.openexchange.office.calcengine.JCalcDocument;
import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.client.config.ClientConfig;
import com.sun.jersey.api.client.config.DefaultClientConfig;

//=============================================================================
public class CalcEngineClientRemote implements ICalcEngineClient
{
    //-------------------------------------------------------------------------
    private static final Log LOG = LogFactory.getLog(CalcEngineClientRemote.class);

    //-------------------------------------------------------------------------
    public CalcEngineClientRemote ()
        throws Exception
    {}
    
    //-------------------------------------------------------------------------
    public void setBaseURI (String sURI)
        throws Exception
    {
        m_sBaseURI = sURI;
    }

    //-------------------------------------------------------------------------
    @Override
    public String createDocument()
        throws Exception
    {
        ClientResponse aResponse = mem_Service().path(CalcEngineConst.CALCENGINE_CONTEXTPATH)
                                                .get (ClientResponse.class );

        boolean bOK = (aResponse.getClientResponseStatus() == ClientResponse.Status.OK);
        if ( ! bOK)
            throw new Exception ("Failed with status : "+aResponse.getStatus());
        
        String        sJSON   = aResponse.getEntity(String.class);
        JCalcDocument aHandle = JCalcDocument.fromJSON(sJSON);
        long          nHandle = aHandle.getHandle();
        Validate.isTrue(nHandle!=JCalcDocument.INVALID_HANDLE, "Invalid handle.");
        
        return String.valueOf(nHandle);
    };
    
    //-------------------------------------------------------------------------
    @Override
    public void destroyDocument(final String sHandle)
        throws Exception
    {
        impl_validateHandleAndFail (sHandle);
        ClientResponse aResponse = mem_Service().path  (CalcEngineConst.CALCENGINE_CONTEXTPATH)
                                                .path  (sHandle                               )
                                                .delete(ClientResponse.class                  );

        boolean bOK = (aResponse.getClientResponseStatus() == ClientResponse.Status.OK);
        if ( ! bOK)
            throw new Exception ("Failed with status : "+aResponse.getStatus());
    };

    //-------------------------------------------------------------------------
    @Override
    public void calculate(final String sHandle)
        throws Exception
    {
        impl_validateHandleAndFail (sHandle);
        ClientResponse aResponse = mem_Service().path(CalcEngineConst.CALCENGINE_CONTEXTPATH)
                                                .path(sHandle                               )
                                                .path(CalcEngineConst.RELPATH_CALCULATE     )
                                                .post(ClientResponse.class                  );

        boolean bOK = (aResponse.getClientResponseStatus() == ClientResponse.Status.OK);
        if ( ! bOK)
            throw new Exception ("Failed with status : "+aResponse.getStatus());
    };

    //-------------------------------------------------------------------------
    @Override
    public String executeOperation(final String sHandle       ,
                                   final String sOperationJSON)
        throws Exception
    {
        impl_validateHandleAndFail (sHandle);
        ClientResponse aResponse = mem_Service().path  (CalcEngineConst.CALCENGINE_CONTEXTPATH    )
                                                .path  (sHandle                                   )
                                                .path  (CalcEngineConst.RELPATH_EXECUTE           )
                                                .entity(sOperationJSON, MediaType.APPLICATION_JSON)
                                                .post  (ClientResponse.class                      );

        boolean bOK = (aResponse.getClientResponseStatus() == ClientResponse.Status.OK);
        if ( ! bOK)
            throw new Exception ("Failed with status : "+aResponse.getStatus());
        
        String sResultJSON = aResponse.getEntity(String.class);
        Validate.notEmpty(sResultJSON, "Invalid JSON result.");
        return sResultJSON;
    };
    
    //-------------------------------------------------------------------------
    private void impl_validateHandleAndFail (final String sHandle)
        throws Exception
    {
        Validate.notEmpty("Invalid handle.", sHandle);
    }
    
    //-------------------------------------------------------------------------
    private ClientConfig mem_Config ()
        throws Exception
    {
        if (m_aConfig == null)
            m_aConfig = new DefaultClientConfig ();
        return m_aConfig;
    }

    //-------------------------------------------------------------------------
    private Client mem_Client ()
        throws Exception
    {
        if (m_aClient == null)
            m_aClient = Client.create(mem_Config ());
        return m_aClient;
    }
 
    //-------------------------------------------------------------------------
    private WebResource mem_Service ()
        throws Exception
    {
        if (m_aService == null)
            m_aService = mem_Client().resource(UriBuilder.fromUri(m_sBaseURI).build());
        return m_aService;
    }
    
    //-------------------------------------------------------------------------
    private String m_sBaseURI = null;

    //-------------------------------------------------------------------------
    private ClientConfig m_aConfig = null;

    //-------------------------------------------------------------------------
    private Client m_aClient = null;

    //-------------------------------------------------------------------------
    private WebResource m_aService = null;
}