/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the Open-Xchange, Inc. group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2004-2012 Open-Xchange, Inc.
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */
package com.openexchange.office.calcengine.client;

import org.apache.commons.lang.Validate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONObject;
import com.openexchange.office.calcengine.CalcEngineNativeWrapper;
import com.openexchange.office.calcengine.JCalcDocument;
import com.openexchange.office.calcengine.JOperation;

//=============================================================================
public class CalcEngineClientInline implements ICalcEngineClient
{
    //-------------------------------------------------------------------------
    private static final Log LOG = LogFactory.getLog(CalcEngineClientInline.class);

    //-------------------------------------------------------------------------
    public CalcEngineClientInline ()
        throws Exception
    {}
    
    //-------------------------------------------------------------------------
    @Override
    public String createDocument()
        throws Exception
    {
        JCalcDocument aHandle = mem_Engine ().createDocument();
        long          nHandle = aHandle.getHandle();
        Validate.isTrue(nHandle!=JCalcDocument.INVALID_HANDLE, "Invalid handle.");
        String        sHandle = String.valueOf(aHandle.getHandle());
        return sHandle;
    };
    
    //-------------------------------------------------------------------------
    @Override
    public void destroyDocument(final String sHandle)
        throws Exception
    {
        impl_validateHandleAndFail (sHandle);
        long          nHandle = Long.parseLong(sHandle);
        JCalcDocument aHandle = new JCalcDocument (nHandle);
        boolean       bOK     = mem_Engine ().destroyDocument(aHandle);
        
        if (! bOK)
            throw new Exception ("Operation failed with FALSE.");
    };

    //-------------------------------------------------------------------------
    @Override
    public void calculate(final String sHandle)
        throws Exception
    {
        impl_validateHandleAndFail (sHandle);
        long          nHandle = Long.parseLong(sHandle);
        JCalcDocument aHandle = new JCalcDocument (nHandle);
        boolean       bOK     = mem_Engine ().calculate(aHandle);
        
        if (! bOK)
            throw new Exception ("Operation failed with FALSE.");
    };

    //-------------------------------------------------------------------------
    @Override
    public String executeOperation(final String sHandle       ,
                                   final String sOperationJSON)
        throws Exception
    {
        impl_validateHandleAndFail (sHandle);
        long          nHandle = Long.parseLong    (sHandle);
        JCalcDocument aHandle = new JCalcDocument (nHandle);
        JOperation    aOp     = new JOperation    (new JSONObject(sOperationJSON));
        boolean       bOK     = mem_Engine ().executeOperation(aHandle, aOp);
        
        if (! bOK)
            throw new Exception ("Operation failed with FALSE.");

        String sResultJSON = aOp.getResult().toString();
        return sResultJSON;
    };
    
    //-------------------------------------------------------------------------
    private void impl_validateHandleAndFail (final String sHandle)
        throws Exception
    {
        Validate.notEmpty("Invalid handle.", sHandle);
        // @todo should we check for LONG handle also ?
    }
    
    //-------------------------------------------------------------------------
    private CalcEngineNativeWrapper mem_Engine ()
       throws Exception
    {
        if (m_aEngine == null)
            m_aEngine = new CalcEngineNativeWrapper ();
        return m_aEngine;
    }
    
    //-------------------------------------------------------------------------
    private CalcEngineNativeWrapper m_aEngine = null;
}