/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the Open-Xchange, Inc. group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2004-2012 Open-Xchange, Inc.
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package com.openexchange.office.calcengine.osgi;

import javax.ws.rs.core.Application;
import org.apache.commons.lang.StringUtils;
import org.osgi.service.http.HttpService;
import com.openexchange.config.ConfigurationService;
import com.openexchange.office.calcengine.CalcEngineConst;
import com.openexchange.office.calcengine.server.CalcEngineServer;
import com.openexchange.osgi.HousekeepingActivator;
import com.sun.jersey.api.core.DefaultResourceConfig;
import com.sun.jersey.spi.container.servlet.ServletContainer;

//-------------------
//- class Activator -
//-------------------

/**
 * {@link HousekeepingActivator}
 */
public class CalcEngineServerActivator extends HousekeepingActivator {

    // -----------------------------------------------------------------------------------

    @Override
    protected Class<?>[] getNeededServices() {
        return new Class<?>[] { HttpService.class, ConfigurationService.class };
    }

    // -----------------------------------------------------------------------------------
 
    @Override
    protected void startBundle() throws Exception {
        final org.apache.commons.logging.Log log = com.openexchange.log.Log.valueOf(com.openexchange.log.LogFactory.getLog(CalcEngineServer.class));
        try
        {
            // HACK
            // (temp solution!)
            //
            // We want to disable calc engine server in case spreadsheet
            // isn't active. Under normal circumstances the Capabality-service
            // has to be asked ... but those service was designed to
            // check capabilities in a user-session-context only.
            // So using that service during bootstrap the backend isn't possible.
            //
            // TODO
            // Separate text/spreadsheet/calcengine and install suitable
            // combination of packages only.
            
            final ConfigurationService configuration = getService(ConfigurationService.class);
            final String permissions = configuration.getProperty("permissions");
            if ( ! StringUtils.containsIgnoreCase(permissions, "spreadsheet")) {
                log.info("CalcEngineServer wont be registered nor activated ... permissions say : no.");
                return;
            }

            
            if (log.isInfoEnabled()) {
                log.info("starting bundle to register CalcEngineServer");
            }
    
            HttpService httpService = getService(HttpService.class);
            if (null == httpService) {
                if (log.isErrorEnabled())
                    log.error("could not register CalcEngineServer at HTTPService");
                return;
            }
                
            CalcEngineServer calcEngine = new CalcEngineServer();

            Application application = new DefaultResourceConfig();
            application.getSingletons().add(calcEngine);
    
            ServletContainer servletContainer = new ServletContainer(application);
    
            httpService.registerServlet(CALCENGINE_PATH, servletContainer, null, null);
            
            if (log.isInfoEnabled()) {
                log.info("successfully registered CalcEngineServer at HTTPService");
            }
        }
        catch (Throwable ex)
        {
            log.error (ex.getMessage(), ex);
            //throw new Exception (ex);
        }
    }

    // -----------------------------------------------------------------------------------

    @Override
    public void stopBundle() {
        final org.apache.commons.logging.Log log = com.openexchange.log.Log.valueOf(com.openexchange.log.LogFactory.getLog(CalcEngineServer.class));
        HttpService httpService = getService(HttpService.class);

        if (null != httpService) {
            if (log.isInfoEnabled()) {
                log.info("unregistering CalcEngineServer");
            }

            httpService.unregister(CALCENGINE_PATH);
        } else if (log.isErrorEnabled()) {
            log.error("could not unregister CalcEngineServer at HTTPService");
        }

        if (log.isInfoEnabled()) {
            log.info("stopping bundle CalcEngineServer");
        }
    }

    // -----------------------------------------------------------------------------------

    final static String CALCENGINE_PATH = CalcEngineConst.CALCENGINE_CONTEXTPATH;
}
