/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the Open-Xchange, Inc. group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2004-2012 Open-Xchange, Inc.
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */
package com.openexchange.office.calcengine.client.impl;

import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.UriBuilder;

import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.openexchange.office.calcengine.CalcEngineConst;
import com.openexchange.office.calcengine.client.CalcEngineConfig;
import com.openexchange.office.calcengine.client.CalcEngineDescriptor;
import com.openexchange.office.calcengine.client.CalcEngineHandleGenerator;
import com.openexchange.office.calcengine.client.ICalcEngineClient;
import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.client.config.ClientConfig;
import com.sun.jersey.api.client.config.DefaultClientConfig;

//=============================================================================
public class CalcEngineClientRemote implements ICalcEngineClient
{
    //-------------------------------------------------------------------------
    private static final Log LOG = LogFactory.getLog(CalcEngineClientRemote.class);

    //-------------------------------------------------------------------------
    private CalcEngineClientRemote ()
        throws Exception
    {}
    
    //-------------------------------------------------------------------------
    public synchronized static CalcEngineClientRemote create()
        throws Exception
    {
    	return new CalcEngineClientRemote ();
    }

    //-------------------------------------------------------------------------
    public void describeEnvironment (final CalcEngineDescriptor aDesc)
        throws Exception
    {
    	m_aDescriptor = aDesc;
    }
    
    //-------------------------------------------------------------------------
    @Override
    public String createDocument()
        throws Exception
    {
        ClientResponse aResponse = mem_Service().path(CalcEngineConst.CALCENGINE_CONTEXTPATH)
                                                .get (ClientResponse.class );

        boolean bOK = (aResponse.getClientResponseStatus() == ClientResponse.Status.OK);
        if ( ! bOK)
            throw new Exception ("Failed with status : "+aResponse.getStatus());
        
        String sJSON   = aResponse.getEntity(String.class);
        String sHandle = CalcEngineHandleGenerator.fromJSON(sJSON);
        
        return sHandle;
    };
    
    //-------------------------------------------------------------------------
    @Override
    public void destroyDocument(final String sHandle)
        throws Exception
    {
        impl_validateHandleAndFail (sHandle);
        ClientResponse aResponse = mem_Service().path  (CalcEngineConst.CALCENGINE_CONTEXTPATH)
                                                .path  (sHandle                               )
                                                .delete(ClientResponse.class                  );

        boolean bOK = (aResponse.getClientResponseStatus() == ClientResponse.Status.OK);
        if ( ! bOK)
            throw new Exception ("Failed with status : "+aResponse.getStatus());
    };

    //-------------------------------------------------------------------------
    @Override
    public String executeOperation(final String sHandle       ,
                                   final String sOperationJSON)
        throws Exception
    {
        impl_validateHandleAndFail (sHandle);
        ClientResponse aResponse = mem_Service().path  (CalcEngineConst.CALCENGINE_CONTEXTPATH    )
                                                .path  (sHandle                                   )
                                                .path  (CalcEngineConst.RELPATH_EXECUTE           )
                                                .entity(sOperationJSON, MediaType.APPLICATION_JSON)
                                                .post  (ClientResponse.class                      );

        boolean bOK = (aResponse.getClientResponseStatus() == ClientResponse.Status.OK);
        if ( ! bOK)
            throw new Exception ("Failed with status : "+aResponse.getStatus());
        
        String sResultJSON = aResponse.getEntity(String.class);
        Validate.notEmpty(sResultJSON, "Invalid JSON result.");
        return sResultJSON;
    };
    //-------------------------------------------------------------------------
    @Override
    public String getVersion()
        throws Exception
    {
        return "";
    }
    
    //-------------------------------------------------------------------------
    private void impl_validateHandleAndFail (final String sHandle)
        throws Exception
    {
        Validate.notEmpty("Invalid handle.", sHandle);
    }
    
    //-------------------------------------------------------------------------
    private ClientConfig mem_ClientConfig ()
        throws Exception
    {
        if (m_aClientConfig == null)
            m_aClientConfig = new DefaultClientConfig ();
        return m_aClientConfig;
    }

    //-------------------------------------------------------------------------
    private Client mem_Client ()
        throws Exception
    {
        if (m_aClient == null)
            m_aClient = Client.create(mem_ClientConfig ());
        return m_aClient;
    }
 
    //-------------------------------------------------------------------------
    private WebResource mem_Service ()
        throws Exception
    {
        if (m_aService == null)
        {
        	final CalcEngineConfig aConfig = CalcEngineConfig.get ();
        	      String           sHost   = m_aDescriptor.m_sHost;
        	      int              nPort   = m_aDescriptor.m_nPort;

        	if (StringUtils.isEmpty(sHost))
        		sHost = aConfig.getServerHost(0);

        	if (nPort < 1)
        		nPort = aConfig.getServerPort(0);
        	
        	Validate.notEmpty(sHost  , "No host configured.");
        	Validate.isTrue  (nPort>0, "No port configured.");

        	final String sBaseURI  = "http://"+sHost+":"+nPort;
            m_aService = mem_Client().resource(UriBuilder.fromUri(sBaseURI).build());
        }
        return m_aService;
    }
    
    //-------------------------------------------------------------------------
    private CalcEngineDescriptor m_aDescriptor = null;

    //-------------------------------------------------------------------------
    private ClientConfig m_aClientConfig = null;

    //-------------------------------------------------------------------------
    private Client m_aClient = null;

    //-------------------------------------------------------------------------
    private WebResource m_aService = null;
}