package com.openexchange.office.tools.executablewrapper;

import java.util.concurrent.CountDownLatch;

import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;

//==============================================================================
public class SimpleExecutableWatcher implements IExecutableWatcher
{
    //--------------------------------------------------------------------------
	private SimpleExecutableWatcher()
	{}
	
    //--------------------------------------------------------------------------
	public static SimpleExecutableWatcher create (final CountDownLatch aSync   ,
												  final String...      lWatches)
	    throws Exception
	{
		Validate.notNull  (aSync   , "Invalid argument 'sync'."              );
		Validate.notNull  (lWatches, "Invalid argument 'watches' (is null)." );
		Validate.notEmpty (lWatches, "Invalid argument 'watches' (is empty).");
		
		SimpleExecutableWatcher aWatcher = new SimpleExecutableWatcher ();
		aWatcher.m_aSync    = aSync   ;
		aWatcher.m_lWatches = lWatches;
		return aWatcher;
	}
	
    //--------------------------------------------------------------------------
	public synchronized String[] getWatchPoints ()
	    throws Exception
	{
		return m_lWatches;
	}

    //--------------------------------------------------------------------------
	public synchronized void watchPointDetected (final String sWatchPoint)
	    throws Exception
	{
		for (String sWatch : m_lWatches)
		{
			if (StringUtils.equals(sWatchPoint, sWatch))
				m_aSync.countDown();
		}
	}

	//--------------------------------------------------------------------------
	private String[] m_lWatches = null;

	//--------------------------------------------------------------------------
	private CountDownLatch m_aSync = null;
}
