/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the Open-Xchange, Inc. group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2004-2012 Open-Xchange, Inc.
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 * This file originates from http://dren.dk/hunspell.html (https://github.com/dren-dk/HunspellJNA)
 *  
 * The Hunspell java bindings are licensed under LGPL, see the file COPYING.txt
 * in the root of the distribution for the exact terms.
 * 
 * @author Flemming Frandsen (flfr at stibo dot com)
 * @date 28/04/2011 (dd/mm/yy)
 *
 */
package com.openexchange.spellchecker.hunspell.jna;

import com.sun.jna.Library;
import com.sun.jna.Pointer;
import com.sun.jna.ptr.PointerByReference;

/**
 * Functions from $hunspell/src/hunspell/hunspell.h
 * 
 * The Hunspell java bindings are licensed under LGPL, see the file COPYING.txt
 * in the root of the distribution for the exact terms.
 * 
 * @author Flemming Frandsen (flfr at stibo dot com)
 */

public interface HunspellLibrary extends Library {

	/**
	 * Create the hunspell instance
	 * 
	 * @param affpath
	 *            The affix file
	 * @param dpath
	 *            The dictionary file
	 * @return The hunspell object
	 */
	public Pointer Hunspell_create(String affpath, String dpath);

	/**
	 * Destroy him my robots...
	 * 
	 * @param pHunspell
	 *            The Hunspell object returned by Hunspell_create
	 */
	public void Hunspell_destroy(Pointer pHunspell);

	/**
	 * Get the dictionary encoding
	 * 
	 * @param pHunspell
	 *            : The Hunspell object returned by Hunspell_create
	 * @return The encoding name
	 */
	public String Hunspell_get_dic_encoding(Pointer pHunspell);

	/**
	 * spell(word) - spellcheck word
	 * 
	 * @param pHunspell
	 *            The Hunspell object returned by Hunspell_create
	 * @param word
	 *            The word to spellcheck.
	 * @return 0 = bad word, not 0 = good word
	 */
	public int Hunspell_spell(Pointer pHunspell, byte[] word);

	/**
	 * Get stems of a word
	 * 
	 * @param pHunspell
	 *            The Hunspell object returned by Hunspell_create
	 * @param slst
	 * @param word
	 *            The word to get the stems for.
	 */
	public int Hunspell_stem(Pointer pHunspell, PointerByReference slst,
			byte[] word);

	/**
	 * Search suggestions
	 * 
	 * @param pHunspell
	 *            The Hunspell object returned by Hunspell_create
	 * @param slst
	 *            input: pointer to an array of strings pointer and the (bad)
	 *            word array of strings pointer (here *slst) may not be
	 *            initialized output: number of suggestions in string array, and
	 *            suggestions in a newly allocated array of strings (*slts will
	 *            be NULL when number of suggestion equals 0.)
	 * @param word
	 *            The word to offer suggestions for.
	 */
	public int Hunspell_suggest(Pointer pHunspell, PointerByReference slst,
			byte[] word);
}
