package org.docx4j.model.listnumbering;

import org.apache.commons.logging.Log;
import com.openexchange.log.LogFactory;

/**
 * This format is 01, 02, 03 etc.
 * Not sure what Word does after 99?
 *
 */
public class NumberFormatDecimalZero extends NumberFormat {

	protected static Log log = LogFactory.getLog(NumberFormatDecimalZero.class);

	@Override
    public String format( int in ) {

		if (in<10) {
			return "0" + in;
		} else {
			return "" + in;
		}
	}

}
