/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the Open-Xchange, Inc. group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2004-2012 Open-Xchange, Inc.
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */
package com.openexchange.office.calcengine.client.impl;

import java.util.HashMap;
import java.util.Map;

import org.apache.commons.lang.Validate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.openexchange.office.calcengine.client.ICalcEngineClient;

//=============================================================================
public class CalcEngineClientSimulator implements ICalcEngineClient
{
    //-------------------------------------------------------------------------
    private static final Log LOG = LogFactory.getLog(CalcEngineClientSimulator.class);

    //-------------------------------------------------------------------------
    private CalcEngineClientSimulator ()
        throws Exception
    {}
    
    //-------------------------------------------------------------------------
    public synchronized static CalcEngineClientSimulator create()
        throws Exception
    {
    	return new CalcEngineClientSimulator ();
    }

    //-------------------------------------------------------------------------
    @Override
    public String createDocument()
        throws Exception
    {
    	final Map< String, Document > lDocs   = mem_Documents ();
    	final String                  sHandle = Integer.toString(lDocs.size()+1);
    	final Document                aDoc    = new Document ();
    	
    	aDoc.sHandle = sHandle;
        lDocs.put (sHandle, aDoc);

    	INFO("created new document with handle ["+sHandle+"] ...");
        return sHandle;
    };
    
    //-------------------------------------------------------------------------
    @Override
    public void destroyDocument(final String sHandle)
        throws Exception
    {
        impl_validateHandleAndFail (sHandle);
        
        final Map< String, Document > lDocs = mem_Documents ();
        lDocs.remove(sHandle);

        INFO("destroyed document with handle ["+sHandle+"] ...");
    };

    //-------------------------------------------------------------------------
    @Override
    public String executeOperation(final String sHandle       ,
                                   final String sOperationJSON)
        throws Exception
    {
        impl_validateHandleAndFail (sHandle);
        
        final Map< String, Document > lDocs = mem_Documents ();
        final Document                aDoc  = lDocs.get(sHandle);
        
        aDoc.lOperations.append (sOperationJSON);
        
        INFO("operation executed on document with handle ["+sHandle+"] ...");
        INFO(sOperationJSON);

        String sResultJSON = sOperationJSON; // put the incoming JSON back as result for testing purposes ... might be an unit test rely on that .-)
        return sResultJSON;
    };
    
    //-------------------------------------------------------------------------
    @Override
    public String getVersion()
    {
        return "No version";
    }
    //-------------------------------------------------------------------------
    private void impl_validateHandleAndFail (final String sHandle)
        throws Exception
    {
        Validate.notEmpty("Invalid handle.", sHandle);

        final Map< String, Document > lDocs = mem_Documents ();
        Validate.isTrue (lDocs.containsKey(sHandle), "Unknown handle '"+sHandle+"'. Are you using the right calc engine instance ?");
    }

    //-------------------------------------------------------------------------
    private static void INFO (final String sMessage)
        throws Exception
    {
    	//System.out.println (sMessage);
    	LOG.info(sMessage);
    }
    
    //-------------------------------------------------------------------------
    private class Document
    {
    	public String       sHandle     = null;
    	public StringBuffer lOperations = new StringBuffer (256);
    }
    
    //-------------------------------------------------------------------------
    private Map< String, Document > mem_Documents ()
    	throws Exception
    {
    	if (m_lDocuments == null)
    		m_lDocuments = new HashMap< String, Document > ();
    	return m_lDocuments;
    }
    
    //-------------------------------------------------------------------------
    private Map< String, Document > m_lDocuments = null;
}
