package com.openexchange.office.calcengine.client;

import org.apache.commons.lang.StringUtils;

//=============================================================================
public enum ECalcEngineMode
{
    //-------------------------------------------------------------------------
    E_INLINE,

    //-------------------------------------------------------------------------
    E_LOCAL,

    //-------------------------------------------------------------------------
    E_REMOTE,

    //-------------------------------------------------------------------------
    E_SIMULATOR;
    
    //-------------------------------------------------------------------------
    public static final String STR_MODE_INLINE    = "inline";
    public static final String STR_MODE_LOCAL     = "local";
    public static final String STR_MODE_REMOTE    = "remote";
    public static final String STR_MODE_SIMULATOR = "simulator";
    
    //-------------------------------------------------------------------------
    public static ECalcEngineMode from (final String          sMode    ,
    		                            final ECalcEngineMode eFallback)
        throws Exception
    {
    	if (StringUtils.equalsIgnoreCase(sMode, STR_MODE_INLINE))
    		return ECalcEngineMode.E_INLINE;

    	if (StringUtils.equalsIgnoreCase(sMode, STR_MODE_LOCAL))
    		return ECalcEngineMode.E_LOCAL;

    	if (StringUtils.equalsIgnoreCase(sMode, STR_MODE_REMOTE))
    		return ECalcEngineMode.E_REMOTE;
    	
    	if (StringUtils.equalsIgnoreCase(sMode, STR_MODE_SIMULATOR))
    		return ECalcEngineMode.E_SIMULATOR;
    	
		return eFallback;
    }
}
