/**
 * This work is provided under the terms of the CREATIVE COMMONS PUBLIC
 * LICENSE. This work is protected by copyright and/or other applicable
 * law. Any use of the work other than as authorized under this license
 * or copyright law is prohibited.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 * Copyright (C) 2016 OX Software GmbH
 * Mail: info@open-xchange.com
 *
 * @author Miroslav Dzunic <miroslav.dzunic@open-xchange.com>
 */

define([
    'io.ox/office/editframework/utils/texture',
    'globals/apphelper',
    'io.ox/office/tk/render/canvas'
], function (Texture, AppHelper, Canvas) {

    'use strict';

    var model;

    // static class Texture ===================================================

    describe('EditFramework module Texture', function () {

        it('should exist', function () {
            expect(Texture).to.be.an('object');
        });

        // private helpers ----------------------------------------------------

        // converts the passed byte array to a 32-bit array
        function to32(a) {
            var result = [];
            for (var i = 0; i < a.length; i += 4) {
                result.push(0x1000000 * a[i] + 0x10000 * a[i + 1] + 0x100 * a[i + 2] + a[i + 3]);
            }
            return result;
        }

        AppHelper.createPresentationApp('ooxml').done(function (app) {
            model = app.getModel();
        });

        var dummyImageUrl = null;
        var canvas = new Canvas('window-0');
        var context;
        canvas.initialize({ width: 250, height: 250 });
        canvas.render(function (cxt) {
            context = cxt;
        });
        //$('body').append(canvas.getNode().css({ zIndex: 99, position: 'fixed', left: '500px' })); // DEBUG

        before(function (done) {
            var helpCanvas = document.createElement('canvas');
            helpCanvas.width = helpCanvas.height = 100;
            var helpCtx = helpCanvas.getContext('2d');

            helpCtx.fillStyle = '#0000ff';
            helpCtx.fillRect(0, 0, 50, 50);
            helpCtx.fillRect(50, 50, 100, 100);

            dummyImageUrl = helpCanvas.toDataURL();
            var fillAttrs = { bitmap: { tiling: { rectAlignment: 'topLeft', flipMode: 'none' }, imageUrl: dummyImageUrl } };

            Texture.getTextureFill(model, context, fillAttrs, 250, 250, null, { isRotateWithShape: true }).then(function (textureFill) {
                context.setFillStyle(textureFill).drawRect(0, 0, 250, 250, 'fill');
            })
            .always(function () {
                done();
            });
        });

        it('should return correct texture', function () {
            expect(to32(context.valueOf().getImageData(0, 0, 5, 5).data)).to.deep.equal([
                0x0000ffff, 0x0000ffff, 0x0000ffff, 0x0000ffff, 0x0000ffff,
                0x0000ffff, 0x0000ffff, 0x0000ffff, 0x0000ffff, 0x0000ffff,
                0x0000ffff, 0x0000ffff, 0x0000ffff, 0x0000ffff, 0x0000ffff,
                0x0000ffff, 0x0000ffff, 0x0000ffff, 0x0000ffff, 0x0000ffff,
                0x0000ffff, 0x0000ffff, 0x0000ffff, 0x0000ffff, 0x0000ffff
            ]);
            expect(to32(context.valueOf().getImageData(51, 0, 5, 5).data)).to.deep.equal([
                0x0000000, 0x0000000, 0x0000000, 0x0000000, 0x0000000,
                0x0000000, 0x0000000, 0x0000000, 0x0000000, 0x0000000,
                0x0000000, 0x0000000, 0x0000000, 0x0000000, 0x0000000,
                0x0000000, 0x0000000, 0x0000000, 0x0000000, 0x0000000,
                0x0000000, 0x0000000, 0x0000000, 0x0000000, 0x0000000
            ]);
            expect(to32(context.valueOf().getImageData(51, 51, 5, 5).data)).to.deep.equal([
                0x0000ffff, 0x0000ffff, 0x0000ffff, 0x0000ffff, 0x0000ffff,
                0x0000ffff, 0x0000ffff, 0x0000ffff, 0x0000ffff, 0x0000ffff,
                0x0000ffff, 0x0000ffff, 0x0000ffff, 0x0000ffff, 0x0000ffff,
                0x0000ffff, 0x0000ffff, 0x0000ffff, 0x0000ffff, 0x0000ffff,
                0x0000ffff, 0x0000ffff, 0x0000ffff, 0x0000ffff, 0x0000ffff
            ]);
            expect(to32(context.valueOf().getImageData(0, 51, 5, 5).data)).to.deep.equal([
                0x0000000, 0x0000000, 0x0000000, 0x0000000, 0x0000000,
                0x0000000, 0x0000000, 0x0000000, 0x0000000, 0x0000000,
                0x0000000, 0x0000000, 0x0000000, 0x0000000, 0x0000000,
                0x0000000, 0x0000000, 0x0000000, 0x0000000, 0x0000000,
                0x0000000, 0x0000000, 0x0000000, 0x0000000, 0x0000000
            ]);
            expect(to32(context.valueOf().getImageData(100, 100, 5, 5).data)).to.deep.equal([
                0x0000ffff, 0x0000ffff, 0x0000ffff, 0x0000ffff, 0x0000ffff,
                0x0000ffff, 0x0000ffff, 0x0000ffff, 0x0000ffff, 0x0000ffff,
                0x0000ffff, 0x0000ffff, 0x0000ffff, 0x0000ffff, 0x0000ffff,
                0x0000ffff, 0x0000ffff, 0x0000ffff, 0x0000ffff, 0x0000ffff,
                0x0000ffff, 0x0000ffff, 0x0000ffff, 0x0000ffff, 0x0000ffff
            ]);
            expect(to32(context.valueOf().getImageData(51, 0, 5, 5).data)).to.deep.equal([
                0x0000000, 0x0000000, 0x0000000, 0x0000000, 0x0000000,
                0x0000000, 0x0000000, 0x0000000, 0x0000000, 0x0000000,
                0x0000000, 0x0000000, 0x0000000, 0x0000000, 0x0000000,
                0x0000000, 0x0000000, 0x0000000, 0x0000000, 0x0000000,
                0x0000000, 0x0000000, 0x0000000, 0x0000000, 0x0000000
            ]);
            expect(to32(context.valueOf().getImageData(151, 151, 5, 5).data)).to.deep.equal([
                0x0000ffff, 0x0000ffff, 0x0000ffff, 0x0000ffff, 0x0000ffff,
                0x0000ffff, 0x0000ffff, 0x0000ffff, 0x0000ffff, 0x0000ffff,
                0x0000ffff, 0x0000ffff, 0x0000ffff, 0x0000ffff, 0x0000ffff,
                0x0000ffff, 0x0000ffff, 0x0000ffff, 0x0000ffff, 0x0000ffff,
                0x0000ffff, 0x0000ffff, 0x0000ffff, 0x0000ffff, 0x0000ffff
            ]);
            expect(to32(context.valueOf().getImageData(100, 151, 5, 5).data)).to.deep.equal([
                0x0000000, 0x0000000, 0x0000000, 0x0000000, 0x0000000,
                0x0000000, 0x0000000, 0x0000000, 0x0000000, 0x0000000,
                0x0000000, 0x0000000, 0x0000000, 0x0000000, 0x0000000,
                0x0000000, 0x0000000, 0x0000000, 0x0000000, 0x0000000,
                0x0000000, 0x0000000, 0x0000000, 0x0000000, 0x0000000
            ]);
        });

        describe('Texture.getTextureFill() as image', function () {
            before(function (done) {
                var helpCanvas = document.createElement('canvas');
                helpCanvas.width = helpCanvas.height = 100;
                var helpCtx = helpCanvas.getContext('2d');

                helpCtx.fillStyle = '#0000ff';
                helpCtx.fillRect(0, 0, 50, 50);
                helpCtx.fillRect(50, 50, 100, 100);

                dummyImageUrl = helpCanvas.toDataURL();
                var fillAttrs = { bitmap: { imageUrl: dummyImageUrl } };

                Texture.getTextureFill(model, context, fillAttrs, 200, 200, null, { isRotateWithShape: true }).then(function (textureFill) {
                    context.clearRect(0, 0, 250, 250);
                    context.setFillStyle(textureFill).drawRect(0, 0, 200, 200, 'fill');
                })
                .always(function () {
                    done();
                });
            });

            it('should return correct image', function () {
                expect(to32(context.valueOf().getImageData(0, 0, 5, 5).data)).to.deep.equal([
                    0x0000ffff, 0x0000ffff, 0x0000ffff, 0x0000ffff, 0x0000ffff,
                    0x0000ffff, 0x0000ffff, 0x0000ffff, 0x0000ffff, 0x0000ffff,
                    0x0000ffff, 0x0000ffff, 0x0000ffff, 0x0000ffff, 0x0000ffff,
                    0x0000ffff, 0x0000ffff, 0x0000ffff, 0x0000ffff, 0x0000ffff,
                    0x0000ffff, 0x0000ffff, 0x0000ffff, 0x0000ffff, 0x0000ffff
                ]);
                expect(to32(context.valueOf().getImageData(51, 51, 5, 5).data)).to.deep.equal([
                    0x0000ffff, 0x0000ffff, 0x0000ffff, 0x0000ffff, 0x0000ffff,
                    0x0000ffff, 0x0000ffff, 0x0000ffff, 0x0000ffff, 0x0000ffff,
                    0x0000ffff, 0x0000ffff, 0x0000ffff, 0x0000ffff, 0x0000ffff,
                    0x0000ffff, 0x0000ffff, 0x0000ffff, 0x0000ffff, 0x0000ffff,
                    0x0000ffff, 0x0000ffff, 0x0000ffff, 0x0000ffff, 0x0000ffff
                ]);
                expect(to32(context.valueOf().getImageData(101, 0, 5, 5).data)).to.deep.equal([
                    0x0000000, 0x0000000, 0x0000000, 0x0000000, 0x0000000,
                    0x0000000, 0x0000000, 0x0000000, 0x0000000, 0x0000000,
                    0x0000000, 0x0000000, 0x0000000, 0x0000000, 0x0000000,
                    0x0000000, 0x0000000, 0x0000000, 0x0000000, 0x0000000,
                    0x0000000, 0x0000000, 0x0000000, 0x0000000, 0x0000000
                ]);
                expect(to32(context.valueOf().getImageData(0, 101, 5, 5).data)).to.deep.equal([
                    0x0000000, 0x0000000, 0x0000000, 0x0000000, 0x0000000,
                    0x0000000, 0x0000000, 0x0000000, 0x0000000, 0x0000000,
                    0x0000000, 0x0000000, 0x0000000, 0x0000000, 0x0000000,
                    0x0000000, 0x0000000, 0x0000000, 0x0000000, 0x0000000,
                    0x0000000, 0x0000000, 0x0000000, 0x0000000, 0x0000000
                ]);
                expect(to32(context.valueOf().getImageData(101, 101, 5, 5).data)).to.deep.equal([
                    0x0000ffff, 0x0000ffff, 0x0000ffff, 0x0000ffff, 0x0000ffff,
                    0x0000ffff, 0x0000ffff, 0x0000ffff, 0x0000ffff, 0x0000ffff,
                    0x0000ffff, 0x0000ffff, 0x0000ffff, 0x0000ffff, 0x0000ffff,
                    0x0000ffff, 0x0000ffff, 0x0000ffff, 0x0000ffff, 0x0000ffff,
                    0x0000ffff, 0x0000ffff, 0x0000ffff, 0x0000ffff, 0x0000ffff
                ]);
                expect(to32(context.valueOf().getImageData(151, 151, 5, 5).data)).to.deep.equal([
                    0x0000ffff, 0x0000ffff, 0x0000ffff, 0x0000ffff, 0x0000ffff,
                    0x0000ffff, 0x0000ffff, 0x0000ffff, 0x0000ffff, 0x0000ffff,
                    0x0000ffff, 0x0000ffff, 0x0000ffff, 0x0000ffff, 0x0000ffff,
                    0x0000ffff, 0x0000ffff, 0x0000ffff, 0x0000ffff, 0x0000ffff,
                    0x0000ffff, 0x0000ffff, 0x0000ffff, 0x0000ffff, 0x0000ffff
                ]);
            });
        });
    });

    // ========================================================================
});
