/* This file has been generated by ox-ui-module generator.
 * Please only apply minor changes (better no changes at all) to this file
 * if you want to be able to run the generator again without much trouble.
 *
 * If you really have to change this file for whatever reason, try to contact
 * the core team and describe your use-case. May be, your changes can be
 * integrated into the templates to be of use for everybody.
 */

'use strict';

module.exports = function (grunt) {
    var appserver = require('appserver');

    grunt.config('connect', {
        server: {
            options: {
                port: 8337,
                protocol: grunt.config('local.appserver.protocol') || 'http',
                base: ['build/'],
                livereload: grunt.config('local.appserver.livereload') || true,
                middleware: function (connect, options, middlewares) {
                    var config = grunt.config().local.appserver;
                    if (config.server === '') {
                        grunt.log.error('Server not specified in grunt/local.conf.json');
                        grunt.log.writeln('Hint: If this is a new setup you may want to copy the file grunt/local.conf.defaults.json to grunt/local.conf.json and change its values according to your setup.');
                        grunt.fail.fatal('Please adjust your local.conf.json');
                    }

                    config.prefixes = (config.prefixes || []).concat([options.base, options.base + '/apps/']);
                    config.manifests = (config.manifests || []).concat(options.base + '/manifests/');
                    config = appserver.tools.unifyOptions(config);

                    // Todo: Take care of middlewares by connect
                    middlewares = [];

                    middlewares.push(appserver.middleware.appsload(config));
                    middlewares.push(appserver.middleware.manifests(config));
                    middlewares.push(appserver.middleware.localfiles(config));
                    middlewares.push(appserver.middleware.proxy(config));
                    return middlewares;
                }
            }
        }
    });

    var defKeyFile = 'ssl/host.key';
    var defCertFile = 'ssl/host.crt';
    var defCaFile = 'ssl/rootCA.crt';

    var keyFile = grunt.config('local.appserver.key');
    var certFile = grunt.config('local.appserver.cert');
    var caFile = grunt.config('local.appserver.ca');

    var key, cert, ca;
    if (keyFile && grunt.file.exists(keyFile)) {
        key = grunt.file.read(keyFile);
    }
    if (certFile && grunt.file.exists(certFile)) {
        cert = grunt.file.read(certFile);
    }
    if (caFile && grunt.file.exists(caFile)) {
        ca = grunt.file.read(caFile);
    }

    if (!key && grunt.file.exists(defKeyFile)) {
        key = grunt.file.read(defKeyFile).toString();
    }
    if (!cert && grunt.file.exists(defCertFile)) {
        cert = grunt.file.read(defCertFile).toString();
    }
    if (!ca && grunt.file.exists(defCaFile)) {
        ca = grunt.file.read(defCaFile).toString();
    }

    grunt.config.set('connect.server.options.key', key || '');
    grunt.config.set('connect.server.options.cert', cert || '');
    grunt.config.set('connect.server.options.ca', ca || '');

    grunt.registerTask('serve', ['connect:server:keepalive']);

    grunt.loadNpmTasks('grunt-contrib-connect');
};
