/**
 * This work is provided under the terms of the CREATIVE COMMONS PUBLIC
 * LICENSE. This work is protected by copyright and/or other applicable
 * law. Any use of the work other than as authorized under this license
 * or copyright law is prohibited.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 * Copyright (C) 2016 OX Software GmbH
 * Mail: info@open-xchange.com
 *
 * @author Daniel Rentz <daniel.rentz@open-xchange.com>
 */

define('io.ox/office/textframework/view/labels', [
    'io.ox/office/editframework/view/editlabels',
    'gettext!io.ox/office/textframework/main'
], function (EditLabels, gt) {

    'use strict';

    // static class TextLabels ================================================

    /**
     * Provides generic caption texts for control groups, menu headers, and
     * other GUI elements for the Text application in a single map for
     * convenience.
     *
     * @extends EditLabels
     */
    var TextLabels = _.extend({}, EditLabels);

    // control labels and icons -----------------------------------------------

    /**
     * Label for drop-down menus.
     */
    TextLabels.MORE_FONT_STYLES_LABEL = gt('More font styles');

    /**
     * @constant
     */
    TextLabels.PARA_ALIGNMENT_LABEL = /*#. horizontal text alignment in a paragraph */ gt('Paragraph alignment');

    /**
     * @constant
     */
    TextLabels.TEXT_POSITION_LABEL = /*#. vertical text position (subscript/superscript) */ gt('Text position');

    /**
     * @constant
     */
    TextLabels.LINE_SPACING_LABEL               = /*#. distance between lines of text within a paragraph   */ gt('Line spacing');
    TextLabels.PARAGRAPH_SPACING_LABEL          = /*#. distance in between two or more selected paragraphs */ gt('Paragraph spacing');
    TextLabels.PARAGRAPH_AND_LINE_SPACING_LABEL = /*#. combined label text of both label texts from above  */ gt('Paragraph & Line spacing');

    /**
     * An array with style options for all supported horizontal paragraph alignments.
     *
     * @constant
     */
    TextLabels.PARA_ALIGNMENT_STYLES = [
        { value: 'left',    icon: 'docs-para-align-left',    label: EditLabels.HOR_ALIGNMENT_LABELS.left },
        { value: 'center',  icon: 'docs-para-align-center',  label: EditLabels.HOR_ALIGNMENT_LABELS.center },
        { value: 'right',   icon: 'docs-para-align-right',   label: EditLabels.HOR_ALIGNMENT_LABELS.right },
        { value: 'justify', icon: 'docs-para-align-justify', label: EditLabels.HOR_ALIGNMENT_LABELS.justify }
    ];

    /**
     * An array with style options for all supported vertical paragraph alignments.
     *
     * @constant
     */
    TextLabels.PARA_VERT_ALIGNMENT_STYLES = [
        { value: 'top',      icon: 'docs-cell-v-align-top',   label: gt('Top') },
        { value: 'centered', icon: 'docs-cell-v-align-middle',  label: gt('Middle') },
        { value: 'bottom',   icon: 'docs-cell-v-align-bottom', label: gt('Bottom') }
    ];

    /**
     * A map with labels for different change tracking actions.
     *
     * @constant
     */
    TextLabels.CHANGE_TRACK_LABELS = {
        inserted: gt('Inserted'),
        removed: gt('Deleted'),
        modified: gt('Formatted')
    };

    // control options --------------------------------------------------------

    /**
     * @constant
     */
    TextLabels.TRACK_CHANGES_OPTIONS = {
        label: /*#. change tracking: toggle the change tracking feature on or off */gt('Track changes'),
        tooltip: gt('Turn change tracking on or off')
    };

    /**
     * @constant
     */
    TextLabels.ACCEPT_AND_NEXT_OPTIONS = {
        label: /*#. change tracking: accept the current document change and jump to the next change */ gt('Accept and next'),
        tooltip: gt('Accept the current change and select the next change')
    };

    /**
     * @constant
     */
    TextLabels.ACCEPT_CURRENT_OPTIONS = {
        label: /*#. change tracking: accept the current document change */gt('Accept this change'),
        tooltip: gt('Accept this change in the document')
    };

    /**
     * @constant
     */
    TextLabels.ACCEPT_ALL_OPTIONS = {
        label: /*#. change tracking: accept all changes in the document */ gt('Accept all changes'),
        tooltip: gt('Accept all changes in the document')
    };

    /**
     * @constant
     */
    TextLabels.REJECT_AND_NEXT_OPTIONS = {
        label: /*#. change tracking: reject the current change and jump to the next change */ gt('Reject and next'),
        tooltip: gt('Reject the current change and select the next change')
    };

    /**
     * @constant
     */
    TextLabels.REJECT_CURRENT_OPTIONS = {
        label: /*#. change tracking: reject the current document change*/ gt('Reject this change'),
        tooltip: gt('Reject this change in the document')
    };

    /**
     * @constant
     */
    TextLabels.REJECT_ALL_OPTIONS = {
        label: /*#. change tracking: reject all changes in this document*/ gt('Reject all changes'),
        tooltip: gt('Reject all changes in the document')
    };

    // stylesheet options --------------------------------------------------------

    /**
     * @constant
     */
    TextLabels.PARAGRAPH_STYLE_LABEL = gt('Paragraph style');

    /**
     * @constant
     */
    TextLabels.APPLY_STYLE_LABEL = gt('Apply style');

    /**
     * @constant
     */
    TextLabels.CHANGE_STYLE_LABEL = gt('Update style');

    /**
     * @constant
     */
    TextLabels.CHANGE_STYLE_LABEL_TOOLTIP = gt('Update current style from selection');

    /**
     * @constant
     */
    TextLabels.RENAME_STYLE_LABEL = gt('Rename style');

    /**
     * @constant
     */
    TextLabels.DELETE_STYLE_LABEL = gt('Delete style');

    /**
     * @constant
     */
    TextLabels.CREATE_STYLE_LABEL = gt('Create new style');

    /**
     * @constant
     */
    TextLabels.CREATE_STYLE_LABEL_TOOLTIP = gt('Create new style from selection');

    // fields options --------------------------------------------------------

    /**
     * @constant
     */
    TextLabels.EDIT_FIELD_OPTIONS = {
        label: /*#. fields: edit format of selected field */gt('Edit field format'),
        tooltip: gt('Edit format of selected field')
    };

    /**
     * @constant
     */
    TextLabels.UPDATE_FIELD_OPTIONS = {
        label: /*#. fields: update selected field */gt('Update field'),
        tooltip: gt('Update selected field')
    };

    /**
     * @constant
     */
    TextLabels.UPDATE_ALL_FIELDS_OPTIONS = {
        label: /*#. fields: update all fields in document */gt('Update all fields'),
        tooltip: gt('Update all fields in document')
    };

    /**
     * @constant
     */
    TextLabels.INSERT_SLIDE_NUMBER_OPTIONS = {
        label: /*#. fields: insert number of the current slide */gt('Slide number'),
        tooltip: gt('Insert current slide number')
    };

    /**
     * @constant
     */
    TextLabels.INSERT_DATE_TIME_OPTIONS = {
        label: /*#. fields: insert current date and time */gt('Date and time'),
        tooltip: gt('Insert current date and time')
    };

    /**
     * @constant
     */
    TextLabels.FOOTER_BUTTON_OPTIONS = {
        label: /*#. fields: insert footer fields */gt('Footer'),
        icon: 'docs-header-footer',
        tooltip: gt('Insert footer with fields like date and slide number'),
        smallerVersion: { hideLabel: true }
    };

    // Anchor label ---------------------------------------------------------

    /**
     * @constant
     */
    TextLabels.GO_TO_ANCHOR_LABEL = {
        label: /*#. anchor link: follow anchor to selected paragraph*/gt('Follow anchor link'),
        tooltip: gt('Click to go to this paragraph in document')
    };

    // exports ================================================================

    return TextLabels;

});
