/**
 * This work is provided under the terms of the CREATIVE COMMONS PUBLIC
 * LICENSE. This work is protected by copyright and/or other applicable
 * law. Any use of the work other than as authorized under this license
 * or copyright law is prohibited.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 * Copyright (C) 2016 OX Software GmbH
 * Mail: info@open-xchange.com
 *
 * @author Daniel Rentz <daniel.rentz@open-xchange.com>
 */

define('io.ox/office/text/model/modelattributesmixin', [
    'io.ox/office/textframework/format/characterstyles',
    'io.ox/office/text/format/paragraphstyles',
    'io.ox/office/text/format/drawingstyles',
    'io.ox/office/text/format/tablecellstyles',
    'io.ox/office/text/format/pagestyles',
    'io.ox/office/textframework/format/tablestyles',
    'io.ox/office/textframework/format/tablerowstyles'
], function (CharacterStyles, ParagraphStyles, DrawingStyles, TableCellStyles, PageStyles, TableStyles, TableRowStyles) {

    'use strict';

    // definitions for global document attributes -----------------------------

    var DOCUMENT_ATTRIBUTE_DEFINITIONS = {

        /**
         * Default tab width in all paragraphs without own tab stop settings,
         * in 1/100 mm.
         */
        defaultTabStop: { def: 1270 }, // 1/2 inch

        /**
         * Current zoom factor.
         */
        zoom: { def: { value: 100 } }, // 100%

        changeTracking: { def: false },

        changeTrackAuthors: { def: [] }
    };

    // definitions for change tracking attributes -----------------------------

    var CHANGES_ATTRIBUTE_DEFINITIONS = {

        inserted: { def: '', scope: 'element' },

        removed: { def: '', scope: 'element' },

        modified: { def: '', scope: 'element' }
    };

    // mix-in class ModelAttributesMixin ======================================

    /**
     * A mix-in class for the document model class TextModel providing the
     * style sheet containers for all attribute families used in a text
     * document.
     *
     * @constructor
     */
    function ModelAttributesMixin() {

        // initialization -----------------------------------------------------

        // global document attributes registration
        this.registerDocumentAttributes(DOCUMENT_ATTRIBUTE_DEFINITIONS);

        // formatting attributes registration
        this.registerAttributes('changes', CHANGES_ATTRIBUTE_DEFINITIONS);

        // style sheet collections
        this.addStyleCollection(new CharacterStyles(this, { families: 'changes' }));
        this.addStyleCollection(new ParagraphStyles(this));
        this.addStyleCollection(new DrawingStyles(this));
        this.addStyleCollection(new TableStyles(this));
        this.addStyleCollection(new TableRowStyles(this));
        this.addStyleCollection(new TableCellStyles(this));
        this.addStyleCollection(new PageStyles(this));

    } // class ModelAttributesMixin

    // exports ================================================================

    return ModelAttributesMixin;

});
