/**
 * This work is provided under the terms of the CREATIVE COMMONS PUBLIC
 * LICENSE. This work is protected by copyright and/or other applicable
 * law. Any use of the work other than as authorized under this license
 * or copyright law is prohibited.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 * Copyright (C) 2016 OX Software GmbH
 * Mail: info@open-xchange.com
 *
 * @author Daniel Rentz <daniel.rentz@open-xchange.com>
 */

define('io.ox/office/spreadsheet/utils/config', [
    'io.ox/office/editframework/utils/editconfig'
], function (EditConfig) {

    'use strict';

    // static class SpreadsheetConfig =========================================

    var SpreadsheetConfig = _.clone(EditConfig);

    /**
     * The configured maximum number of non-empty cells allowed to be contained
     * in a complete spreadsheet document.
     *
     * @constant
     */
    SpreadsheetConfig.MAX_CELL_COUNT = EditConfig.getInt('spreadsheet/maxCells', 500000);

    /**
     * The configured maximum number of sheets allowed to be contained in a
     * spreadsheet document.
     *
     * @constant
     */
    SpreadsheetConfig.MAX_SHEET_COUNT = EditConfig.getInt('spreadsheet/maxSheets', 256);

    /**
     * The configured maximum number of formulas allowed to be contained in a
     * spreadsheet document.
     *
     * @constant
     */
    SpreadsheetConfig.MAX_FORMULA_COUNT = EditConfig.getInt('spreadsheet/maxFormulas', 10000);

    // exports ================================================================

    return SpreadsheetConfig;

});
