/**
 * This work is provided under the terms of the CREATIVE COMMONS PUBLIC
 * LICENSE. This work is protected by copyright and/or other applicable
 * law. Any use of the work other than as authorized under this license
 * or copyright law is prohibited.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 * Copyright (C) 2016 OX Software GmbH
 * Mail: info@open-xchange.com
 *
 * @author Daniel Rentz <daniel.rentz@open-xchange.com>
 */

define('io.ox/office/settings/view/settingslabels', [
    'gettext!io.ox/office/settings/main'
], function (gt) {

    'use strict';

    // static class BaseLabels ================================================

    /**
     * Provides generic caption texts for control groups, menu headers, and
     * other GUI elements in a single map for convenience.
     */
    var SettingsLabels = {};

    /**
     * Label for settings panel-entry and its header
     *
     * @constant
     */
    SettingsLabels.DOCUMENTS_HEADER_LABEL = gt('Documents');

    // template labels ---------------------------------------------------------

    /**
     * Label for user's template folder
     *
     * @constant
     */
    SettingsLabels.USER_TEMPLATE_FOLDER = gt('My template folders');

    /**
     * Label for global template folder created by the context admin
     *
     * @constant
     */
    SettingsLabels.GLOBAL_TEMPLATE_FOLDER = gt('Global template folders');

    /**
     * dialog header to choose a new template folder
     *
     * @constant
     */
    SettingsLabels.SELECT_TEMPLATE_FOLDER = gt('Select template folder');

    /**
     * button label to choose a new template folder
     *
     * @constant
     */
    SettingsLabels.ADD_NEW_TEMPLATE_FOLDER = gt('Add new template folder');

    /**
     * dialog ok button label
     *
     * @constant
     */
    SettingsLabels.OK_LABEL = gt('OK');

    // permissions labels ---------------------------------------------------------

    /**
     * permissions button label to open Drive's permission dialog
     *
     * @constant
     */
    SettingsLabels.PERMISSIONS_LABEL = gt('Permissions');

    /**
     * permissions message is triggered after context admin chose a new template folder
     *
     * @constant
     */
    SettingsLabels.PERMISSIONS_MESSAGE_LABEL = gt('To grant users access to all templates in this folder, please use the Permission dialog. All users need to be able to read all objects in this folder.');

    // measurements labels ---------------------------------------------------------

    /**
     * Header for measurements settings
     *
     * @constant
     */
    SettingsLabels.MEASUREMENTS = gt('Measurements');

    /**
     * Label for measurements settings
     *
     * @constant
     */
    SettingsLabels.MEASUREMENTS_LABEL = /*#. Show measurements in units of "milimeter" or "centimeter" or "inch" */ gt('Show measurements in units of');

    /**
     * centimeter label used in measurements settings drop-down
     *
     * @constant
     */
    SettingsLabels.CENTIMETER_LABEL = gt('centimeter');

    /**
     * millimeter label used in measurements settings drop-down
     *
     * @constant
     */
    SettingsLabels.MILLIMETER_LABEL = gt('millimeter');

    /**
     * inch label used in measurements settings drop-down
     *
     * @constant
     */
    SettingsLabels.INCH_LABEL = gt('inch');

    // exports ================================================================

    return SettingsLabels;

});
