/**
 * This work is provided under the terms of the CREATIVE COMMONS PUBLIC
 * LICENSE. This work is protected by copyright and/or other applicable
 * law. Any use of the work other than as authorized under this license
 * or copyright law is prohibited.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 * Copyright (C) 2016 OX Software GmbH
 * Mail: info@open-xchange.com
 *
 * @author Peter Seliger <peter.seliger@open-xchange.com>
 */

define('io.ox/office/settings/spellchecking', [
    'io.ox/core/event',
    'io.ox/office/tk/config',
    'gettext!io.ox/office/settings/main'
], function (Event, Config, gt) {

    'use strict';

    // the key for save/get the state of a user's spell-check settings.
    var SETTINGS_KEY = 'isCheckSpellingPermanently';

    // class SpellChecking ----------------------------------------------------

    // NOTE: there are no app specific spell-check user settings anymore due to DOCS-630
    // - see comments section and attachments ...
    //   ... [https://jira.open-xchange.com/browse/DOCS-630]

    var SpellChecking = Event.extend(function () {

        // public methods -----------------------------------------------------
        this.refresh = function (settings) {
            settings.appendTitle(/*#. Label for a user's Spell-Checking section in the documents settings */gt('Spell checking'));

            settings.appendCheckbox(
                /*#. checkbox label that states whether or not to (permanently) check for spelling errors */gt('Check for errors permanently'),
                'isCheckErrors',
                SpellChecking.isOnlineSpelling(),
                function (event) { SpellChecking.setOnlineSpelling(event.target.checked); }
            );
            settings.append($('<div style="display: block; height: 0; margin-bottom: 20px">'));
        };
    });

    // static methods ---------------------------------------------------------

    SpellChecking.isOnlineSpelling = function () {
        return Config.get(SETTINGS_KEY, true);
    };

    SpellChecking.setOnlineSpelling = function (state) {
        Config.set(SETTINGS_KEY, state);
    };

    // exports ----------------------------------------------------------------

    return SpellChecking;
});
