/**
 * This work is provided under the terms of the CREATIVE COMMONS PUBLIC
 * LICENSE. This work is protected by copyright and/or other applicable
 * law. Any use of the work other than as authorized under this license
 * or copyright law is prohibited.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 * Copyright (C) 2016 OX Software GmbH
 * Mail: info@open-xchange.com
 *
 * @author Stefan Eckert <stefan.eckert@open-xchange.com>
 */

define('io.ox/office/presentation/view/statuspane', [
    'io.ox/office/tk/utils',
    'io.ox/office/baseframework/view/toolpane',
    'io.ox/office/baseframework/view/toolbar',
    'io.ox/office/textframework/view/controls',
    'gettext!io.ox/office/presentation/main'
], function (Utils, ToolPane, ToolBar, Controls, gt) {

    'use strict';

    // convenience shortcuts
    var Button = Controls.Button;
    var Label = Controls.Label;

    // class StatusPane =======================================================

    /**
     *
     * @constructor
     *
     * @extends ToolPane
     *
     * @param {PresentationView} docView
     *  The presentation view containing this instance.
     */
    function StatusPane(docView) {

        var self = this;
        var app = docView.getApp();
        var docModel = app.getModel();

        // base constructor ---------------------------------------------------

        ToolPane.call(this, docView, { position: 'bottom', classes: 'status-pane standard-design dark-topbar-background-design' });

        // private methods ----------------------------------------------------

        function updateHandler() {
            var visible = docModel.isMasterView() && !Utils.isSoftKeyboardOpen();
            self.toggle(visible);
        }
        // initialization -----------------------------------------------------

        var labelToolBar = new ToolBar(docView);
        labelToolBar.addGroup(null, new Label(docView, { label: gt('You are in the slide master view.'), tooltip: gt('You are in the slide master view.') }));
        self.addViewComponent(labelToolBar, { targetArea: 'center' });

        var buttonToolBar = new ToolBar(docView);
        buttonToolBar.addGroup('debug/normalslideview', new Button(docView, { label: gt('Close'), tooltip: 'Leave slide master view' }));
        self.addViewComponent(buttonToolBar, { targetArea: 'trailing' });

        if (_.browser.Android) {
            //".window-container" is oriented in screen with "top left right bottom" set to zero,
            //when the soft keyboard on Android devices pops up, the status bar stays over the keyboard
            //this makes no sense and looks ugly, so we detect the open keyboard and hide the status pane
            app.registerWindowResizeHandler(updateHandler);
        }

        self.listenTo(docModel, 'change:activeView:after', updateHandler);
        self.listenTo(app, 'docs:editmode', updateHandler);

        // no event after opening app
        self.hide();

        // destroy class members on destruction
        this.registerDestructor(function () {
            self = app = docView = docModel = labelToolBar = buttonToolBar = null;
        });

    } // class StatusPane

    // exports ================================================================

    // derive this class from class ToolPane
    return ToolPane.extend({ constructor: StatusPane });

});
