/**
 * This work is provided under the terms of the CREATIVE COMMONS PUBLIC
 * LICENSE. This work is protected by copyright and/or other applicable
 * law. Any use of the work other than as authorized under this license
 * or copyright law is prohibited.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 * Copyright (C) 2016 OX Software GmbH
 * Mail: info@open-xchange.com
 *
 * @author Ingo Schmidt-Rosbiegal <ingo.schmidt-rosbiegal@open-xchange.com>
 */

define('io.ox/office/presentation/utils/operations', [
    'io.ox/office/textframework/utils/operations'
], function (BaseTextOperations) {

    'use strict';

    // static class PresentationOperations ====================================

    /**
     * Provides constants for the names of all document operations used in
     * presentation documents.
     *
     * @extends BaseTextOperations
     */
    var PresentationOperations = BaseTextOperations.extend({

        SLIDE_INSERT: 'insertSlide',
        MASTER_SLIDE_INSERT: 'insertMasterSlide',
        LAYOUT_SLIDE_INSERT: 'insertLayoutSlide',
        LAYOUT_SLIDE_MOVE: 'moveLayoutSlide',
        MASTER_CHANGE: 'changeMaster', // only supported in ODF
        LAYOUT_CHANGE: 'changeLayout',
        SLIDE_MOVE: 'moveSlide'
    });

    // exports ================================================================

    return PresentationOperations;

});
