/**
 * This work is provided under the terms of the CREATIVE COMMONS PUBLIC
 * LICENSE. This work is protected by copyright and/or other applicable
 * law. Any use of the work other than as authorized under this license
 * or copyright law is prohibited.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 * Copyright (C) 2016 OX Software GmbH
 * Mail: info@open-xchange.com
 *
 * @author Michael Nimz <michael.nimz@open-xchange.com>
 */

/* eslint no-new: 0 */

define('io.ox/office/portal/i18n', [
    'io.ox/core/gettext',
    'gettext!io.ox/office/portal/main'
], function (gettext, gt) {
    'use strict';

    /* Just list all custom translations.
      The build system recognizes these strings and collects them in a POT file,
      so that they can be subject to translation processes. At runtime, gt('...')
      returns translations for current language.
   */
    if (false) {
        gt.pgettext('app', 'Text');
        gt.pgettext('app', 'Spreadsheet');
        gt.pgettext('app', 'Presentation');
    }

    // get internal dictionary
    var dictionary = gt.getDictionary();

    // add all translations to global dictionary
    gettext.addTranslation('*', dictionary);
});
