/**
 * This work is provided under the terms of the CREATIVE COMMONS PUBLIC
 * LICENSE. This work is protected by copyright and/or other applicable
 * law. Any use of the work other than as authorized under this license
 * or copyright law is prohibited.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 * Copyright (C) 2016 OX Software GmbH
 * Mail: info@open-xchange.com
 *
 * @author Daniel Rentz <daniel.rentz@open-xchange.com>
 */

define('io.ox/office/editframework/view/editcontrols', [
    'io.ox/office/tk/utils',
    'io.ox/office/baseframework/view/basecontrols',
    'io.ox/office/drawinglayer/view/drawingcontrols',
    'io.ox/office/editframework/view/editlabels',
    'io.ox/office/editframework/view/control/applicationstatuslabel',
    'io.ox/office/editframework/view/control/acquireeditbutton',
    'io.ox/office/editframework/view/control/filenamefield',
    'io.ox/office/editframework/view/control/colorpicker',
    'io.ox/office/editframework/view/control/bordermodepicker',
    'io.ox/office/editframework/view/control/borderstylepicker',
    'io.ox/office/editframework/view/control/borderwidthpicker',
    'io.ox/office/editframework/view/control/fontfamilypicker',
    'io.ox/office/editframework/view/control/fontsizepicker',
    'io.ox/office/editframework/view/control/stylesheetpicker',
    'io.ox/office/editframework/view/control/languagepicker',
    'io.ox/office/editframework/view/control/tablesizepicker',
    'io.ox/office/editframework/view/control/tablestylepicker',
    'io.ox/office/editframework/view/control/userbadge',
    'io.ox/office/editframework/view/control/toolbartabgroup',
    'io.ox/office/editframework/view/control/toolbartablist'
], function (Utils, BaseControls, DrawingControls, Editlabels, ApplicationStatusLabel, AcquireEditButton, FileNameField, ColorPicker, BorderModePicker, BorderStylePicker, BorderWidthPicker, FontFamilyPicker, FontSizePicker, StyleSheetPicker, LanguagePicker, TableSizePicker, TableStylePicker, UserBadge, ToolBarTabGroup, ToolBarTabList) {

    'use strict';

    // static class EditControls ==============================================

    /**
     * Provides different classes for GUI form controls. Collects all standard
     * control group classes defined in the toolkit, and adds more controls in
     * a single map for convenience.
     *
     * @extends BaseControls
     * @extends DrawingControls
     */
    var EditControls = _.extend({}, BaseControls, DrawingControls, {
        ApplicationStatusLabel: ApplicationStatusLabel,
        AcquireEditButton: AcquireEditButton,
        FileNameField: FileNameField,
        ColorPicker: ColorPicker,
        BorderModePicker: BorderModePicker,
        BorderStylePicker: BorderStylePicker,
        BorderWidthPicker: BorderWidthPicker,
        FontFamilyPicker: FontFamilyPicker,
        FontSizePicker: FontSizePicker,
        StyleSheetPicker: StyleSheetPicker,
        LanguagePicker: LanguagePicker,
        TableSizePicker: TableSizePicker,
        TableStylePicker: TableStylePicker,
        UserBadge: UserBadge,
        ToolBarTabGroup: ToolBarTabGroup,
        ToolBarTabList: ToolBarTabList
    });

    // class TextColorPicker ==================================================

    /**
     * A color picker control for selecting a text color. The list entry for
     * the automatic color will be shown as 'Black' by default, but can be
     * changed with the method ColorPicker.setAutoColor().
     *
     * @constructor
     *
     * @extends ColorPicker
     *
     * @param {EditView} docView
     *  The document view that contains this color picker.
     *
     * @param {Object} [initOptions]
     *  Optional parameters. Supports all options of the ColorPicker base
     *  class.
     */
    EditControls.TextColorPicker = ColorPicker.extend({ constructor: function (docView, initOptions) {

        ColorPicker.call(this, docView, 'text', Utils.extendOptions(Editlabels.TEXT_COLORPICKER_OPTIONS, initOptions));

    } }); // class TextColorPicker

    // class FillColorPicker ==================================================

    /**
     * A color picker control for selecting a fill color. The list entry for
     * the automatic color will be shown as 'No fill' by default, but can be
     * changed with the method ColorPicker.setAutoColor().
     *
     * @constructor
     *
     * @extends ColorPicker
     *
     * @param {EditView} docView
     *  The document view that contains this color picker.
     *
     * @param {Object} [initOptions]
     *  Optional parameters. Supports all options of the ColorPicker base
     *  class.
     */
    EditControls.FillColorPicker = ColorPicker.extend({ constructor: function (docView, initOptions) {

        ColorPicker.call(this, docView, 'fill', Utils.extendOptions(Editlabels.FILL_COLORPICKER_OPTIONS, initOptions));

    } }); // class FillColorPicker

    // class BorderColorPicker ==================================================

    /**
     * A color picker control for selecting a border color.
     *
     * @constructor
     *
     * @extends ColorPicker
     *
     * @param {Object} [initOptions]
     *  Optional parameters. Supports all options of the RadioList base class
     */
    EditControls.BorderColorPicker = ColorPicker.extend({ constructor: function (docView, initOptions) {

        ColorPicker.call(this, docView, null, Utils.extendOptions(Editlabels.BORDER_COLORPICKER_OPTIONS, initOptions));

    } }); // class BorderColorPicker

    // class BorderPresetStylePicker ==========================================

    /**
     * A drop-down list control for border line styles used in OOXML files.
     *
     * @constructor
     *
     * @extends EditControls.BorderStylePicker
     *
     * @param {Object} [initOptions]
     *  Optional parameters. Supports all options supported by the base class
     *  EditControls.BorderStylePicker.
     */
    EditControls.BorderPresetStylePicker = EditControls.BorderStylePicker.extend({ constructor: function (docView, listEntries, initOptions) {

        // base constructor ---------------------------------------------------

        EditControls.BorderStylePicker.call(this, docView, listEntries, Utils.extendOptions({
            label: Editlabels.BORDER_STYLE_LABEL,
            smallerVersion: { hideLabel: true }
        }, initOptions));

    } }); // class BorderPresetStylePicker

    // class ArrowPresetStylePicker ==========================================

    // exports ================================================================

    return EditControls;

});
