/**
 * This work is provided under the terms of the CREATIVE COMMONS PUBLIC
 * LICENSE. This work is protected by copyright and/or other applicable
 * law. Any use of the work other than as authorized under this license
 * or copyright law is prohibited.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 * Copyright (C) 2016 OX Software GmbH
 * Mail: info@open-xchange.com
 *
 * @author Daniel Rentz <daniel.rentz@open-xchange.com>
 */

define('io.ox/office/drawinglayer/view/control/chartlegendpicker', [
    'io.ox/office/tk/utils',
    'io.ox/office/tk/control/radiolist',
    'gettext!io.ox/office/drawinglayer/main'
], function (Utils, RadioList, gt) {

    'use strict';

    // class ChartLegendPicker ================================================

    /**
     * A drop-down menu for picking the position of the chart legend.
     *
     * @constructor
     *
     * @extends RadioList
     *
     * @param {Object} [initOptions]
     *  Optional parameters. Supports all options of the base class RadioList.
     */
    function ChartLegendPicker(docView, initOptions) {

        // base constructor ---------------------------------------------------

        RadioList.call(this, docView, Utils.extendOptions({
            label: /*#. menu title: positions for the legend in a chart object */ gt.pgettext('chart-legend', 'Legend position'),
            tooltip: /*#. menu tooltip: positions for the legend in a chart object */ gt.pgettext('chart-legend', 'Visibility and position of the chart legend')
        }, initOptions, {
            updateCaptionMode: 'none'
        }));

        // initialization -----------------------------------------------------

        this.createOptionButton('off',      { section: 'off', label: /*#. chart legend is hidden */ gt.pgettext('chart-legend', 'Off') })
            .createOptionButton('top',      { section: 'pos', label: /*#. chart legend at top of border of the chart */ gt.pgettext('chart-legend', 'Top') })
            .createOptionButton('bottom',   { section: 'pos', label: /*#. chart legend at bottom border of the chart */ gt.pgettext('chart-legend', 'Bottom') })
            .createOptionButton('left',     { section: 'pos', label: /*#. chart legend at left border of the chart */ gt.pgettext('chart-legend', 'Left') })
            .createOptionButton('right',    { section: 'pos', label: /*#. chart legend at right border of the chart */ gt.pgettext('chart-legend', 'Right') });

    } // class ChartLegendPicker

    // exports ================================================================

    // derive this class from class RadioList
    return RadioList.extend({ constructor: ChartLegendPicker });

});
