/**
 * This work is provided under the terms of the CREATIVE COMMONS PUBLIC
 * LICENSE. This work is protected by copyright and/or other applicable
 * law. Any use of the work other than as authorized under this license
 * or copyright law is prohibited.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 * Copyright (C) 2016 OX Software GmbH
 * Mail: info@open-xchange.com
 *
 * @author Daniel Rentz <daniel.rentz@open-xchange.com>
 */

define('io.ox/office/drawinglayer/model/chartmodel', [
    'io.ox/office/drawinglayer/model/drawingmodel'
], function (DrawingModel) {

    'use strict';

    // class ChartModel =======================================================

    /**
     * The model of a chart object.
     *
     * Additionally to the events triggered by the base class DrawingModel,
     * instances of this class trigger the following 'change:drawing' events:
     * - 'insert:series'
     *      After a new data series has been inserted into this chart. Event
     *      handlers receive the array index of the new data series.
     * - 'delete:series'
     *      After an existing data series has been deleted from this chart.
     *      Event handlers receive the last array index of the data series.
     * - 'change:series'
     *      After an existing data series has been changed in this chart. Event
     *      handlers receive the array index of the data series.
     *
     * @constructor
     *
     * @extends DrawingModel
     *
     * @param {DrawingCollection} parentCollection
     *  The parent drawing collection that will contain this drawing object.
     *
     * @param {Object} [initAttributes]
     *  An attribute set with initial formatting attributes for the object.
     */
    var ChartModel = DrawingModel.extend({ constructor: function (parentCollection, initAttributes) {

        // base constructor ---------------------------------------------------

        DrawingModel.call(this, parentCollection, 'chart', initAttributes, { families: 'chart fill' });

        // initialization -----------------------------------------------------

        // destroy all class members on destruction
        this.registerDestructor(function () {
            parentCollection = initAttributes = null;
        });

    } }); // class ChartModel

    // exports ================================================================

    return ChartModel;

});
