/**
 * This work is provided under the terms of the CREATIVE COMMONS PUBLIC
 * LICENSE. This work is protected by copyright and/or other applicable
 * law. Any use of the work other than as authorized under this license
 * or copyright law is prohibited.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 * Copyright (C) 2016 OX Software GmbH
 * Mail: info@open-xchange.com
 *
 * @author Daniel Rentz <daniel.rentz@open-xchange.com>
 */

define('io.ox/office/baseframework/utils/baseconfig', [
    'io.ox/core/capabilities',
    'io.ox/office/tk/config'
], function (Capabilities, Config) {

    'use strict';

    // static class BaseConfig ================================================

    var BaseConfig = _.clone(Config);

    // constants --------------------------------------------------------------

    /**
     * Specifies whether the OX Mail application is available.
     *
     * @constant
     *
     * @type {Boolean}
     */
    BaseConfig.MAIL_AVAILABLE = Capabilities.has('webmail');

    /**
     * Specifies whether the OX Contacts application is available.
     *
     * @constant
     *
     * @type {Boolean}
     */
    BaseConfig.CONTACTS_AVAILABLE = Capabilities.has('contacts');

    /**
     * Specifies whether the server-side document converter is available.
     *
     * @constant
     *
     * @type {Boolean}
     */
    BaseConfig.CONVERTER_AVAILABLE = Capabilities.has('document_preview');

    /**
     * Specifies whether the OX Presenter application is available to play a
     * presentation document.
     *
     * @constant
     *
     * @type {Boolean}
     */
    BaseConfig.PRESENTER_AVAILABLE = BaseConfig.CONVERTER_AVAILABLE && Capabilities.has('presenter');

    /**
     * Specifies whether the OX Presenter application is able to play a remote
     * presentation.
     *
     * @constant
     *
     * @type {Boolean}
     */
    BaseConfig.REMOTE_PRESENTER_AVAILABLE = BaseConfig.PRESENTER_AVAILABLE && Capabilities.has('remote_presenter');

    // exports ================================================================

    return BaseConfig;

});
