/**
 * This work is provided under the terms of the CREATIVE COMMONS PUBLIC
 * LICENSE. This work is protected by copyright and/or other applicable
 * law. Any use of the work other than as authorized under this license
 * or copyright law is prohibited.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 * Copyright (C) 2016 OX Software GmbH
 * Mail: info@open-xchange.com
 *
 * @author Michael Nimz <michael.nimz@open-xchange.com>
 */

define([
    'io.ox/office/portal/collection/documentcollection'
], function (DocumentCollection) {

    'use strict';

    // class DocumentCollection ===============================================

    describe('Portal class DocumentCollection', function () {

        it('should exist', function () {
            expect(DocumentCollection).to.be.a('function');
        });

        it('should have method "setData"', function () {
            var collection = new DocumentCollection();
            expect(collection).to.respondTo('setData');
        });

        it('should catch data', function () {
            var collection = new DocumentCollection();
            collection.setData(['one', 'two', 'three']);
            expect(collection.length).to.be.equal(3);
        });
    });

    // ========================================================================
});
