/**
 * This work is provided under the terms of the CREATIVE COMMONS PUBLIC
 * LICENSE. This work is protected by copyright and/or other applicable
 * law. Any use of the work other than as authorized under this license
 * or copyright law is prohibited.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 * Copyright (C) 2016 OX Software GmbH
 * Mail: info@open-xchange.com
 *
 * @author Michael Nimz <michael.nimz@open-xchange.com>
 */

define([
    'io.ox/office/baseframework/app/baseapplication',
    'io.ox/office/baseframework/model/basemodel',
    'io.ox/office/baseframework/view/baseview',
    'io.ox/office/baseframework/app/basecontroller'
], function (BaseApplication, BaseModel, BaseView, BaseController) {

    'use strict';

    // class BaseApplication ==================================================

    describe('BaseFramework class BaseApplication', function () {

        it('should exist', function () {
            expect(BaseApplication).to.be.a('function');
        });

        // private helpers ----------------------------------------------------

        function importHandler() { return $.when(); }
        var importSpy = sinon.spy(importHandler);

        var app = null;
        before(function () {
            app = ox.ui.createApp({ name: 'io.ox/office/baseframework' });
            var appWindow = ox.ui.createWindow({ name: 'io.ox/office/baseframework' });
            appWindow.isBusy = _.constant(false);
            app.setWindow(appWindow);
            app.setLauncher(_.noop);
            app.setState = _.noop;
        });

        // constructor --------------------------------------------------------

        describe('constructor', function () {
            before(function () {
                BaseApplication.call(app, BaseModel, BaseView, BaseController, importSpy, { action: 'load', file: { id: '1', folder_id: '1' } });
            });
            it('should extend a new application instance', function () {
                expect(app).to.respondTo('getDocumentType');
                expect(app).to.respondTo('getModel');
                expect(app).to.respondTo('getView');
                expect(app).to.respondTo('getController');
            });
            it('should remove a few core methods', function () {
                expect(app).to.not.respondTo('setLauncher');
                expect(app).to.not.respondTo('setQuit');
            });
            it('should provide methods of BaseObject', function () {
                expect(app).to.respondTo('registerDestructor');
                expect(app).to.respondTo('waitForSuccess');
                expect(app).to.respondTo('waitForFailure');
                expect(app).to.respondTo('waitForAny');
            });
            it('should provide methods of TimerMixin', function () {
                expect(app).to.respondTo('executeDelayed');
                expect(app).to.respondTo('createDebouncedMethod');
            });
            it('should provide methods of AppObjectMixin', function () {
                expect(app).to.respondTo('waitForImportStart');
                expect(app).to.respondTo('waitForImportSuccess');
                expect(app).to.respondTo('waitForImportFailure');
                expect(app).to.respondTo('waitForImport');
            });
        });

        // launcher -----------------------------------------------------------

        describe('launcher', function () {
            it('should initalize the application', function (done) {
                app.launch();
                app.waitForImport(function () {
                    sinon.assert.calledOnce(importSpy);
                    done();
                });
            });
        });

        // public methods -----------------------------------------------------

        describe('method "getDocumentType"', function () {
            it('should exist', function () {
                expect(app).to.respondTo('getDocumentType');
            });
            it('should return the module name', function () {
                expect(app.getDocumentType()).to.equal('baseframework');
            });
        });

        describe('method "getModel"', function () {
            it('should exist', function () {
                expect(app).to.respondTo('getModel');
            });
            it('should return a document model', function () {
                expect(app.getModel()).to.be.an.instanceof(BaseModel);
            });
        });

        describe('method "getView"', function () {
            it('should exist', function () {
                expect(app).to.respondTo('getView');
            });
            it('should return a document view', function () {
                expect(app.getView()).to.be.an.instanceof(BaseView);
            });
        });

        describe('method "getController"', function () {
            it('should exist', function () {
                expect(app).to.respondTo('getController');
            });
            it('should return a document controller', function () {
                expect(app.getController()).to.be.an.instanceof(BaseController);
            });
        });
    });

    // ========================================================================
});
