/**
 * This work is provided under the terms of the CREATIVE COMMONS PUBLIC
 * LICENSE. This work is protected by copyright and/or other applicable
 * law. Any use of the work other than as authorized under this license
 * or copyright law is prohibited.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 * Copyright (C) 2016 OX Software GmbH
 * Mail: info@open-xchange.com
 *
 * @author Daniel Rentz <daniel.rentz@open-xchange.com>
 */

define('io.ox/office/tk/controls', [
    'io.ox/office/tk/control/group',
    'io.ox/office/tk/control/label',
    'io.ox/office/tk/control/button',
    'io.ox/office/tk/control/checkbox',
    'io.ox/office/tk/control/radiogroup',
    'io.ox/office/tk/control/checkgroup',
    'io.ox/office/tk/control/radiolist',
    'io.ox/office/tk/control/textfield',
    'io.ox/office/tk/control/unitfield',
    'io.ox/office/tk/control/combofield',
    'io.ox/office/tk/control/spinfield'
], function (Group, Label, Button, CheckBox, RadioGroup, CheckGroup, RadioList, TextField, UnitField, ComboField, SpinField) {

    'use strict';

    // static class Controls ==================================================

    /**
     * Provides different classes for GUI form controls. Collects all standard
     * control group classes defined in the toolkit in a single map for
     * convenience.
     */
    var Controls = {
        Group: Group,
        Label: Label,
        Button: Button,
        CheckBox: CheckBox,
        RadioGroup: RadioGroup,
        CheckGroup: CheckGroup,
        RadioList: RadioList,
        TextField: TextField,
        UnitField: UnitField,
        ComboField: ComboField,
        SpinField: SpinField
    };

    // exports ================================================================

    return Controls;

});
