/**
 * This work is provided under the terms of the CREATIVE COMMONS PUBLIC
 * LICENSE. This work is protected by copyright and/or other applicable
 * law. Any use of the work other than as authorized under this license
 * or copyright law is prohibited.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 * Copyright (C) 2016 OX Software GmbH
 * Mail: info@open-xchange.com
 *
 * @author Daniel Rentz <daniel.rentz@open-xchange.com>
 */

define('io.ox/office/textframework/view/control/liststylepicker', [
    'io.ox/office/tk/utils',
    'io.ox/office/tk/control/radiolist'
], function (Utils, RadioList) {

    'use strict';

    // class ListStylePicker ==================================================

    /**
     * Base class for a drop-down list control containing different styles for
     * bullet lists, or numbered lists.
     *
     * @constructor
     *
     * @extends RadioList
     */
    function ListStylePicker(docView, predefinedListStyles, initOptions) {

        var // self reference
            self = this,

            // CSS font family of the 'Cambria' font (with fall-back fonts)
            fontFamily = docView.getDocModel().getCssFontFamily('Cambria'),

            // font attributes for the drop-down list entries
            labelStyle = 'font-family:' + fontFamily + ';font-size:18px;min-width:18px;',

            // the id that can be used for 'No Symbol' in bullet or numbering list selection
            noListItemId = Utils.getStringOption(initOptions, 'noListItemId', '');

        // base constructor ---------------------------------------------------

        RadioList.call(this, Utils.extendOptions({
            highlight: function (listStyleId) { return listStyleId !== '' && (noListItemId === '' || listStyleId !== noListItemId); },
            splitValue: docView.getDocModel().getDefaultListValue(),
            updateCaptionMode: 'none',
            itemDesign: 'grid',
            sortItems: true
        }, initOptions));

        // initialization -----------------------------------------------------

        // create the list entries
        self.createMenuSection('default').createMenuSection('special', { gridColumns: 1 });
        _.each(predefinedListStyles, function (listStyle, listStyleId) {
            if (Utils.trimAndCleanString(listStyle.listLabel).length > 0) {
                self.createOptionButton(listStyleId, {
                    section: 'default',
                    label: _.noI18n(listStyle.listLabel),
                    labelStyle: labelStyle,
                    tooltip: _.noI18n(listStyle.tooltip),
                    dataValue: listStyle.listKey,
                    sortIndex: listStyleId
                });
            } else {
                self.createOptionButton(listStyleId, {
                    section: 'special',
                    label: _.noI18n(listStyle.tooltip),
                    dataValue: listStyle.listKey
                });
            }
        });

        this.getMenuNode().addClass('list-style-picker');

        // destroy class members
        this.registerDestructor(function () {
            self = docView = predefinedListStyles = initOptions = null;
        });

    } // class ListStylePicker

    // exports ================================================================

    // derive this class from class RadioList
    return RadioList.extend({ constructor: ListStylePicker });

});
