/**
 * This work is provided under the terms of the CREATIVE COMMONS PUBLIC
 * LICENSE. This work is protected by copyright and/or other applicable
 * law. Any use of the work other than as authorized under this license
 * or copyright law is prohibited.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 * Copyright (C) 2016 OX Software GmbH
 * Mail: info@open-xchange.com
 *
 * @author Daniel Rentz <daniel.rentz@open-xchange.com>
 */

define('io.ox/office/spreadsheet/view/control/formatcategorypicker', [
    'io.ox/office/tk/utils',
    'io.ox/office/tk/control/radiolist',
    'io.ox/office/spreadsheet/view/labels',
    'gettext!io.ox/office/spreadsheet/main'
], function (Utils, RadioList, Labels, gt) {

    'use strict';

    // class FormatCategoryPicker =============================================

    /**
     * A drop-down list control for choosing number format categories, that
     * will load predefined format codes in the format code picker control.
     *
     * @constructor
     *
     * @extends RadioList
     *
     * @param {SpreadsheetView} docView
     *  The document view containing this instance.
     *
     * @param {Object} [initOptions]
     *  Optional parameters. Supports all options of the base class RadioList.
     */
    function FormatCategoryPicker(docView, initOptions) {

        // base constructors --------------------------------------------------

        RadioList.call(this, Utils.extendOptions({
            label: _.noI18n('123'),
            tooltip: gt('Number format')
        }, initOptions, {
            updateCaptionMode: 'none'
        }));

        // initialization -----------------------------------------------------

        this.getNode().addClass('format-category-group');

        // insert all supported list items
        Labels.FORMAT_CATEGORY_LIST.forEach(function (categoryData) {
            if (categoryData.name !== 'custom') {
                this.createOptionButton(categoryData.name, { label: categoryData.label });
            }
        }, this);

        // destroy all class members on destruction
        this.registerDestructor(function () {
            docView = initOptions = null;
        });

    } // class FormatCategoryPicker

    // exports ================================================================

    // derive this class from class RadioList
    return RadioList.extend({ constructor: FormatCategoryPicker });

});
