/**
 * This work is provided under the terms of the CREATIVE COMMONS PUBLIC
 * LICENSE. This work is protected by copyright and/or other applicable
 * law. Any use of the work other than as authorized under this license
 * or copyright law is prohibited.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 * Copyright (C) 2016 OX Software GmbH
 * Mail: info@open-xchange.com
 *
 * @author Daniel Rentz <daniel.rentz@open-xchange.com>
 */

define('io.ox/office/spreadsheet/model/formula/funcs/webfuncs', function () {

    'use strict';

    /**************************************************************************
     *
     * This module implements all spreadsheet functions dealing with web
     * content.
     *
     * See the README file in this directory for a detailed documentation about
     * the format of function descriptor objects.
     *
     *************************************************************************/

    // exports ================================================================

    return {

        DDE: {
            category: 'web',
            name: { ooxml: null },
            hidden: true,
            minParams: 3,
            maxParams: 4,
            type: 'val'
        },

        ENCODEURL: {
            category: 'web',
            name: { ooxml: '_xlfn.ENCODEURL', odf: 'COM.MICROSOFT.ENCODEURL' },
            minParams: 1,
            maxParams: 1,
            type: 'val',
            signature: 'val:str'
        },

        FILTERXML: {
            category: 'web',
            name: { ooxml: '_xlfn.FILTERXML', odf: 'COM.MICROSOFT.FILTERXML' },
            minParams: 1,
            maxParams: 1,
            type: 'val'
        },

        HYPERLINK: {
            category: 'web',
            minParams: 1,
            maxParams: 2,
            type: 'val',
            recalc: 'once',
            signature: 'val:str val:any',
            resolve: function (url, value) {
                var result = this.isMissingOperand(1) ? url : value;
                return this.createOperand(result, { url: url });
            }
        },

        RTD: {
            category: 'web',
            name: { odf: null },
            hidden: true,
            minParams: 3,
            type: 'val'
        },

        WEBSERVICE: {
            category: 'web',
            name: { ooxml: '_xlfn.WEBSERVICE', odf: 'COM.MICROSOFT.WEBSERVICE' },
            hidden: true,
            minParams: 1,
            maxParams: 1,
            type: 'val',
            signature: 'val:str'
        }
    };

});
