/**
 * This work is provided under the terms of the CREATIVE COMMONS PUBLIC
 * LICENSE. This work is protected by copyright and/or other applicable
 * law. Any use of the work other than as authorized under this license
 * or copyright law is prohibited.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 * Copyright (C) 2016 OX Software GmbH
 * Mail: info@open-xchange.com
 *
 * @author Stefan Eckert <stefan.eckert@open-xchange.com>
 */

define('io.ox/office/settings/units', [
    'io.ox/office/tk/locale/localedata',
    'io.ox/office/settings/view/settingslabels',
    'settings!io.ox/office'
], function (LocaleData, Labels, Settings) {

    'use strict';

    var ALL_UNITS = {
        cm: {
            label: Labels.CENTIMETER_LABEL,
            step: 0.1
        },
        mm: {
            label: Labels.MILLIMETER_LABEL,
            step: 1
        },
        in: {
            label: Labels.INCH_LABEL,
            step: 0.05
        }
    };

    // private global functions ===============================================

    function getStandardUnit() {
        var unit = Settings.get('units/standard');
        return unit ? unit : LocaleData.UNIT;
    }

    function setStandardUnit(unit) {
        Settings.set('units/standard', unit).save();
    }

    // class Units ============================================================

    function Units() {

        // public methods -----------------------------------------------------

        this.refresh = function (settings) {
            settings.appendTitle(Labels.MEASUREMENTS);

            var folders = $('<ul class="list-unstyled publications list-group widget-list">');

            settings.append(folders);

            var standardUnit = getStandardUnit();

            var select = $('<select id="io-ox-office-standard-units" class="form-control">');
            _.each(ALL_UNITS, function (data, unit) {
                var option = $('<option>').text(data.label).val(unit);
                if (unit === standardUnit) {
                    option.attr('selected', true);
                }
                select.append(option);
            });

            select.change(function () {
                setStandardUnit(this.value);
            });

            var label = $('<label class="control-label col-sm-4" for="io-ox-office-standard-units">').text(Labels.MEASUREMENTS_LABEL);
            var div = $('<div class="col-sm-4">').append(select);
            var form = $('<div class="form-group clearfix">').append(label, div);

            settings.append(form, '<div style="display:block;height:20px;">');
        };

    } // class Units

    // static methods ---------------------------------------------------------

    Units.getStandardUnit = getStandardUnit;

    Units.getStandardUnitStep = function () {
        return ALL_UNITS[getStandardUnit()].step;
    };

    // exports ================================================================

    return Units;

});
