/**
 * This work is provided under the terms of the CREATIVE COMMONS PUBLIC
 * LICENSE. This work is protected by copyright and/or other applicable
 * law. Any use of the work other than as authorized under this license
 * or copyright law is prohibited.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 * Copyright (C) 2016 OX Software GmbH
 * Mail: info@open-xchange.com
 *
 * @author Stefan Eckert <stefan.eckert@open-xchange.com>
 */

define('io.ox/office/settings/register', [
    'io.ox/core/extensions',
    'io.ox/core/manifests',
    'io.ox/office/tk/io',
    'io.ox/office/tk/utils/driveutils',
    'io.ox/office/settings/templatefolders',
    'io.ox/office/settings/templatemodel',
    'io.ox/office/settings/contexttemplatemodel',
    'io.ox/office/settings/view/settingslabels',
    'io.ox/office/settings/units',
    'io.ox/office/settings/userdictionary',
    'io.ox/office/tk/utils/deferredutils'
], function (ext, Manifests, IO, DriveUtils, TemplateFolders, TemplateModel, ContextTemplateModel, Labels, Units, UserDictionary, DeferredUtils) {

    'use strict';

    var inited = false;

    var Register = {};

    Register.init = function (manifestPath) {

        if (inited) {
            return;
        }

        //TODO: this is not the best way!!!
        if (Manifests.manager.isDisabled(manifestPath)) {
            return;
        }

        var self = this;

        inited = true;

        //extend the global settings with office settings
        ext.point('io.ox/settings/pane/main').extend({
            id: 'io.ox/office',
            title: 'Documents',
            ref: 'io.ox/office',
            loadSettingPane: false,
            index: 4000
        });

        var settingsObject = {};
        var settingsNode = null;
        var subSettings = [];

        subSettings.push(new Units());

        subSettings.push(new UserDictionary());

        if (!DriveUtils.isGuest()) {

            subSettings.push(new TemplateFolders(new TemplateModel('MyTemplateFolders'), { title: Labels.USER_TEMPLATE_FOLDER, useMyFiles: true }));

            checkAdmin().always(function () {
                var resolved = this.state() === 'resolved';
                var model = null;

                var init = function () {
                    subSettings.push(new TemplateFolders(model, { title: Labels.GLOBAL_TEMPLATE_FOLDER, readOnly: !resolved, showReadAccess: resolved }));
                };

                if (resolved) {
                    model = new TemplateModel('ContextTemplateFolders');
                    init();
                } else {
                    IO.sendRequest(IO.FILTER_MODULE_NAME, { action: 'getcontexttemplatefolders' }).done(function (data) {
                        model = new ContextTemplateModel(data);
                        init();
                    });
                }
            });
        }

        /**
         * standard options section-title
         */
        settingsObject.appendTitle = function (title) {
            var tt = $('<legend class="sectiontitle">');
            tt.text(title);
            settingsNode.append(tt);
            return tt;
        };

        /**
         * standard dialog button
         */
        settingsObject.appendButton = function (title, listener) {
            var btn = $('<button type="button" class="btn btn-primary" tabindex="0">');
            btn.text(title).on('click', listener);
            settingsNode.append(btn);
            return btn;
        };

        settingsObject.append = function (node) {
            settingsNode.append(node);
        };

        var first = true;

        var innerDraw = function () {

            settingsNode = this;

            settingsNode.empty();
            settingsNode.append($('<h1>').text(Labels.DOCUMENTS_HEADER_LABEL));

            _.each(subSettings, function (subSetting) {
                subSetting.refresh(settingsObject);
            });

            if (first) {
                first = false;
                var settingsWindow = ox.ui.windowManager.getWindows().filter(function (win) { return win.name === 'io.ox/settings'; })[0];

                var thizz = this;

                var refresh = function () {
                    settingsWindow.app.folder.getData().done(function (model) {
                        if (model.id === 'virtual/settings/io.ox/office') {
                            innerDraw.apply(thizz, arguments);
                        }
                    });
                };

                ox.on('refresh^', refresh);
                settingsWindow.on('beforeshow', refresh);
            }
        };

        function checkAdmin() {
            var resp = $.ajax('/ajax/user/me?session=' + ox.session, {
                type: 'GET',
                dataType: 'json'
            });
            var ret = DeferredUtils.createDeferred(self, 'Register: checkAdmin');
            resp.done(function (answer) {
                if (answer.data.user_id && answer.data.user_id === answer.data.context_admin) {
                    ret.resolve();
                } else {
                    ret.reject();
                }
            });
            resp.fail(ret.reject);
            return ret;
        }

        //office settings
        ext.point('io.ox/office/settings/detail').extend({
            index: 100,
            draw: innerDraw
        });

    };

    return Register;
});
