/**
 * This work is provided under the terms of the CREATIVE COMMONS PUBLIC
 * LICENSE. This work is protected by copyright and/or other applicable
 * law. Any use of the work other than as authorized under this license
 * or copyright law is prohibited.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 * Copyright (C) 2016 OX Software GmbH
 * Mail: info@open-xchange.com
 *
 * @author Peter Seliger <peter.seliger@open-xchange.com>
 */

define('io.ox/office/presentation/view/controls', [
    'io.ox/office/tk/utils',
    'io.ox/office/textframework/view/controls',
    'io.ox/office/presentation/view/control/layoutslidepicker',
    'gettext!io.ox/office/presentation/main'
], function (Utils, TextControls, LayoutSlidePicker, gt) {

    'use strict';

    var EDIT_MASTER_LABEL = /* start to edit master/layout slides of a presentation */ gt('Edit master');

    var EDIT_NORMAL_LABEL = /* start to (or return to) edit normal slides of a presentation */ gt('Edit normal');

    // static class PresentationControls ======================================

    /**
     * Provides different classes for GUI form controls for presentation objects
     * collected within a single map for convenience.
     */
    var PresentationControls = _.extend({}, TextControls);

    // class InsertLayoutSlidePicker ==========================================

    PresentationControls.InsertLayoutSlidePicker = LayoutSlidePicker.extend({ constructor: function (docView, initOptions) {

        LayoutSlidePicker.call(this, docView, Utils.extendOptions({
            label: gt('Slide'),
            tooltip: gt('Insert new slide'),
            icon: 'fa-plus',
            splitValue: 'blank_slide'
        }, initOptions));

    } }); // class InsertLayoutSlidePicker

    // class ChangeLayoutSlidePicker ==========================================

    PresentationControls.ChangeLayoutSlidePicker = LayoutSlidePicker.extend({ constructor: function (docView, initOptions) {

        LayoutSlidePicker.call(this, docView, Utils.extendOptions({
            label: gt('Layout'),
            tooltip: gt('Change layout'),
            icon: 'fa-columns',
            updateCaptionMode: 'none',
            boundingBox: docView.getApp().getRootNode()
        }, initOptions));

    } }); // class ChangeLayoutSlidePicker

    // class SwitchLayoutNormalButton =========================================

    PresentationControls.SwitchSlideEditModeButton = TextControls.Button.extend({ constructor: function (docView, initOptions) {

        var self = this;

        // base constructor ---------------------------------------------------

        TextControls.Button.call(this, Utils.extendOptions({
            label: EDIT_MASTER_LABEL,
            icon: 'docs-slide-master',
            tooltip: gt('Switch between editing master/layout slides and normal slides')
        }, initOptions));

        // initialization -----------------------------------------------------

        this.listenTo(docView.getDocModel(), 'change:activeView:after', function (event, options) {
            self.setLabel(options.isMasterView ? EDIT_NORMAL_LABEL : EDIT_MASTER_LABEL);
        });

    } }); // class SwitchSlideEditModeButton

    // exports ================================================================

    return PresentationControls;

});
