/**
 * This work is provided under the terms of the CREATIVE COMMONS PUBLIC
 * LICENSE. This work is protected by copyright and/or other applicable
 * law. Any use of the work other than as authorized under this license
 * or copyright law is prohibited.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 * Copyright (C) 2016 OX Software GmbH
 * Mail: info@open-xchange.com
 *
 * @author Daniel Rentz <daniel.rentz@open-xchange.com>
 */

define('io.ox/office/portal/text/fulltour', [
    'io.ox/office/baseframework/utils/baseconfig',
    'io.ox/office/portal/portaltour',
    'gettext!io.ox/office/portal/main'
], function (BaseConfig, PortalTour, gt) {

    'use strict';

    // class TextFullTour =====================================================

    /**
     * The guided tour for the Text Portal application.
     *
     * @constructor
     *
     * @extends PortalTour
     */
    var TextFullTour = PortalTour.extend({ constructor: function (initOptions) {

        // base constructor ---------------------------------------------------

        PortalTour.call(this, 'text', initOptions);

        // initialization -----------------------------------------------------

        // the initial welcome message
        this.welcomeStep()
            .title(gt.pgettext('tour', 'The Text app'))
            .content(gt.pgettext('tour', 'Welcome to your new Text app. This Guided Tour will introduce you to the most important functions of creating and editing text documents online.'));

        // highlight the header of the template area
        this.templatesAreaStep()
            .title(gt.pgettext('tour', 'Templates'))
            .content(gt.pgettext('tour', 'Clicking on the Text app in the navigation bar displays an overview of all the templates available to you in Text.'));

        // describe the 'Blank document' button
        this.blankDocumentStep()
            .title(gt.pgettext('tour', 'Blank text document'))
            .content(gt.pgettext('tour', 'You can choose from a variety of templates to help you create professional documents.'))
            .content($('<br>'))
            .content(gt.pgettext('tour', 'Let\'s start with a blank document.'));

        // launch the editor application with a new empty document
        this.launchDocumentStep();

        // insert document contents, show the 'Saving changes' label
        this.autoSaveStep(function () {
            this.getDocModel().insertText('Lorem ipsum dolor sit amet.', [0, 0]);
        });

        // describe the 'File' toolbar
        this.fileTabStep();
        this.saveAsStep();
        if (BaseConfig.MAIL_AVAILABLE) { this.sendAsMailStep({ asDropDown: true }); }

        // describe the 'Close' button, switch to 'Documents' folder in Drive
        this.closeButtonStep();
        this.documentsFolderStep();

        // final tour step describing how to restart the tour, return to Drive application with the Back button
        this.restartTourStep().on('back', this.launchDriveApp.bind(this));

    } }); // class TextFullTour

    // exports ================================================================

    return TextFullTour;

});
