/**
 * This work is provided under the terms of the CREATIVE COMMONS PUBLIC
 * LICENSE. This work is protected by copyright and/or other applicable
 * law. Any use of the work other than as authorized under this license
 * or copyright law is prohibited.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 * Copyright (C) 2016 OX Software GmbH
 * Mail: info@open-xchange.com
 *
 * @author Daniel Rentz <daniel.rentz@open-xchange.com>
 */

define('io.ox/office/editframework/view/editlabels', [
    'io.ox/office/baseframework/view/baselabels',
    'io.ox/office/drawinglayer/view/drawinglabels',
    'gettext!io.ox/office/editframework/main'
], function (BaseLabels, DrawingLabels, gt) {

    'use strict';

    // static class EditLabels ================================================

    /**
     * Provides generic caption texts for control groups, menu headers, and
     * other GUI elements in a single map for convenience.
     *
     * @extends BaseLabels
     * @extends DrawingLabels
     */
    var EditLabels = _.extend({}, BaseLabels, DrawingLabels);

    // constants for header labels --------------------------------------------

    /**
     * @constant
     */
    EditLabels.FILE_HEADER_LABEL =
        //#. menu title: file settings and actions (download, rename, etc.)
        gt.pgettext('menu-title', 'File');

    /**
     * @constant
     */
    EditLabels.FORMAT_HEADER_LABEL =
        //#. menu title: font settings, colors, text alignment, etc.
        gt.pgettext('menu-title', 'Format');

    /**
     * @constant
     */
    EditLabels.INSERT_HEADER_LABEL =
        //#. menu title: insert images, charts, hyperlinks, etc.
        gt.pgettext('menu-title', 'Insert');

    /**
     * @constant
     */
    EditLabels.FONT_HEADER_LABEL =
        //#. menu title: font settings (font name, size, text color, bold/italic, etc.)
        gt.pgettext('menu-title', 'Font');

    /**
     * @constant
     */
    EditLabels.ALIGNMENT_HEADER_LABEL =
        //#. menu title: alignment settings for text in paragraphs or table cells
        gt.pgettext('menu-title', 'Alignment');

    /**
     * @constant
     */
    EditLabels.NUMBERFORMAT_HEADER_LABEL =
        //#. menu title: number format settings for table cells
        gt.pgettext('menu-title', 'Number format');

    /**
     * @constant
     */
    EditLabels.SLIDE_HEADER_LABEL =
        //#. menu title: settings for a single presentation slide
        gt.pgettext('menu-title', 'Slide');

    /**
     * @constant
     */
    EditLabels.TABLE_HEADER_LABEL =
        //#. menu title: settings for a single text table
        gt.pgettext('menu-title', 'Table');

    /**
     * @constant
     */
    EditLabels.REVIEW_HEADER_LABEL =
        //#. menu title: settings for document review (spelling, track/accept/reject changes)
        gt.pgettext('menu-title', 'Review');

    /**
     * @constant
     */
    EditLabels.CHANGETRACKING_HEADER_LABEL =
        //#. menu title: settings for document review (spelling, track/accept/reject changes)
        gt.pgettext('menu-title', 'Change tracking');

    /**
     * @constant
     */
    EditLabels.PARAGRAPH_STYLES_LABEL =
        //#. menu title: paragraph style sets (including sets of font-size, text color, bold/italic, etc.)
        gt.pgettext('menu-title', 'Paragraph styles');

    /**
     * @constant
     */
    EditLabels.PARAGRAPH_LABEL =
        //#. menu title: paragraph (including sets of font-size, text color, bold/italic, etc.)
        gt.pgettext('menu-title', 'Paragraph');

    /**
     * @constant
     */
    EditLabels.LIST_SETTINGS_LABEL =
        //#. menu title: list settings (bullet list, numbered list, list-icon, etc.)
        gt.pgettext('menu-title', 'List settings');

    /**
     * @constant
     */
    EditLabels.FONT_STYLES_LABEL =
        //#. menu title: font styles (font name, size, text color, bold/italic, etc.)
        gt.pgettext('menu-title', 'Font styles');

    /**
     * @constant
     */
    EditLabels.CELL_BORDER_LABEL =
        //#. menu title: cell border settings for table cells
        gt.pgettext('menu-title', 'Cell border');

    // other control label texts ----------------------------------------------

    /**
     * @constant
     */
    EditLabels.CELL_BORDERS_LABEL =
        //#. cell border settings for table cells
        gt.pgettext('borders', 'Cell borders');

    /**
     * @constant
     */
    EditLabels.BORDER_COLOR_LABEL =
        //#. line color of borders in paragraphs and tables cells
        gt.pgettext('borders', 'Border color');

    /**
     * @constant
     */
    EditLabels.BORDER_STYLE_LABEL =
        //#. line style of borders in paragraphs and tables cells
        gt.pgettext('borders', 'Border style');

    /**
     * @constant
     */
    EditLabels.CLEAR_FORMAT_LABEL =
        //#. clear all manual formatting of text or table cells (back to default style)
        gt('Clear formatting');

    /**
     * Menu labels for horizontal text alignment.
     *
     * @constant
     */
    EditLabels.HOR_ALIGNMENT_LABELS = {
        left:    /*#. horizontal alignment of text in paragraphs or cells */ gt.pgettext('h-alignment', 'Left'),
        center:  /*#. horizontal alignment of text in paragraphs or cells */ gt.pgettext('h-alignment', 'Center'),
        right:   /*#. horizontal alignment of text in paragraphs or cells */ gt.pgettext('h-alignment', 'Right'),
        justify: /*#. horizontal alignment of text in paragraphs or cells */ gt.pgettext('h-alignment', 'Justify'),
        auto:    /*#. horizontal alignment of text in paragraphs or cells (automatically dependent on contents: text left, numbers right) */ gt.pgettext('h-alignment', 'Automatic')
    };

    /**
     * Menu labels for vertical text alignment.
     *
     * @constant
     */
    EditLabels.VERT_ALIGNMENT_LABELS = {
        top:     /*#. vertical alignment of text in table cells */ gt.pgettext('v-alignment', 'Top'),
        middle:  /*#. vertical alignment of text in table cells */ gt.pgettext('v-alignment', 'Middle'),
        bottom:  /*#. vertical alignment of text in table cells */ gt.pgettext('v-alignment', 'Bottom'),
        justify: /*#. vertical alignment of text in table cells */ gt.pgettext('v-alignment', 'Justify')
    };

    // hyperlink labels -------------------------------------------------------

    /**
     * @constant
     */
    EditLabels.HYPERLINK_LABEL = gt('Hyperlink');

    /**
     * @constant
     */
    EditLabels.EDIT_HYPERLINK_LABEL = gt('Edit hyperlink');

    /**
     * @constant
     */
    EditLabels.REMOVE_HYPERLINK_LABEL = gt('Remove hyperlink');

    /**
     * @constant
     */
    EditLabels.OPEN_HYPERLINK_LABEL = gt('Open hyperlink');

    /**
     * @constant
     */
    EditLabels.INSERT_HYPERLINK_LABEL = gt('Insert hyperlink');

    /**
     * @constant
     */
    EditLabels.INSERT_OR_EDIT_HYPERLINK_LABEL = gt('Insert or edit a hyperlink');

    /**
     * @constant
     */
    EditLabels.INVALID_HYPERLINK_LABEL = gt('This hyperlink is invalid.');

    // dialog labels ----------------------------------------------------------

    /**
     * Dialog title for a warning query dialog.
     *
     * @constant
     */
    EditLabels.DELETE_CONTENTS_TITLE = /*#. dialog title for "Do you want to delete" query */ gt('Delete Contents');

    /**
     * Message text for a warning query dialog.
     *
     * @constant
     */
    EditLabels.DELETE_CONTENTS_QUERY = gt('Deleting the selected elements cannot be undone. Do you want to continue?');

    /**
     * Dialog title for a warning query dialog.
     *
     * @constant
     */
    EditLabels.DELETE_ROWS_TITLE = /*#. dialog title for "Do you want to delete" query */ gt('Delete Rows');

    /**
     * Message text for a warning query dialog.
     *
     * @constant
     */
    EditLabels.DELETE_ROWS_QUERY = gt('Deleting the selected rows cannot be undone. Do you want to continue?');

    /**
     * Dialog title for a warning query dialog.
     *
     * @constant
     */
    EditLabels.DELETE_COLUMNS_TITLE = /*#. dialog title for "Do you want to delete" query */ gt('Delete Columns');

    /**
     * Message text for a warning query dialog.
     *
     * @constant
     */
    EditLabels.DELETE_COLUMNS_QUERY = gt('Deleting the selected columns cannot be undone. Do you want to continue?');

    // options for controls ---------------------------------------------------

    /**
     * Standard options for a 'Bold' toggle button.
     *
     * @constant
     */
    EditLabels.BOLD_BUTTON_OPTIONS = {
        icon: 'docs-font-bold',
        tooltip: gt('Bold'),
        toggle: true,
        dropDownVersion: { label: gt('Bold') }
    };

    /**
     * Standard options for an 'Italic' toggle button.
     *
     * @constant
     */
    EditLabels.ITALIC_BUTTON_OPTIONS = {
        icon: 'docs-font-italic',
        tooltip: gt('Italic'),
        toggle: true,
        dropDownVersion: { label: gt('Italic') }
    };

    /**
     * Standard options for an 'Underline' toggle button.
     *
     * @constant
     */
    EditLabels.UNDERLINE_BUTTON_OPTIONS = {
        icon: 'docs-font-underline',
        tooltip: gt('Underline'),
        toggle: true,
        dropDownVersion: { label: gt('Underline') }
    };

    /**
     * Standard options for a 'Strike through' toggle button.
     *
     * @constant
     */
    EditLabels.STRIKEOUT_BUTTON_OPTIONS = {
        icon: 'docs-font-strikeout',
        tooltip: gt('Strike through'),
        toggle: true,
        dropDownVersion: { label: gt('Strike through') }
    };

    /**
     * Standard options for a 'Clear formatting' button.
     *
     * @constant
     */
    EditLabels.CLEAR_FORMAT_BUTTON_OPTIONS = {
        icon: 'docs-reset-formatting',
        tooltip: EditLabels.CLEAR_FORMAT_LABEL,
        dropDownVersion: { label: EditLabels.CLEAR_FORMAT_LABEL }
    };

    /**
     * Standard options for a 'Insert hyperlink' button.
     *
     * @constant
     */
    EditLabels.INSERT_HYPERLINK_OPTIONS = {
        label: EditLabels.HYPERLINK_LABEL,
        tooltip: EditLabels.INSERT_HYPERLINK_LABEL
    };

    /**
     * Standard options for a 'Insert/edit hyperlink' button.
     *
     * @constant
     */
    EditLabels.HYPERLINK_BUTTON_OPTIONS = {
        icon: 'docs-hyperlink',
        label: EditLabels.HYPERLINK_LABEL,
        tooltip: EditLabels.INSERT_OR_EDIT_HYPERLINK_LABEL,
        smallerVersion: {
            css: { width: 35 },
            hideLabel: true
        }
    };

    /**
     * Standard options for a 'Show toolbar' check box.
     *
     * @constant
     */
    EditLabels.SHOW_TOOLBARS_CHECKBOX_OPTIONS = {
        label: /*#. check box label: show/hide the upper toolbar panel */ gt('Show toolbars'),
        tooltip: /*#. check box tooltip: show/hide the upper toolbar panel */ gt('Show or hide the toolbars'),
        flatPane: 'hide'
    };

    /**
     * Standard options for a 'Show sidebar' check box.
     *
     * @constant
     */
    EditLabels.SHOW_SLIDEBAR_CHECKBOX_OPTIONS = {
        label: /*#. check box label: show/hide the sidebar panel */ gt('Show sidebar'),
        tooltip: /*#. check box tooltip: show/hide the sidebar panel */ gt('Show or hide the sidebar'),
        flatPane: 'hide'
    };

    /**
     * Standard options for a 'Show collaborators' check box.
     *
     * @constant
     */
    EditLabels.SHOW_COLLABORATORS_CHECKBOX_OPTIONS = {
        label: /*#. check box label: show/hide the collaborator list */ gt('Show collaborators'),
        tooltip: /*#. check box tooltip: show/hide the collaborator list */ gt('Show or hide list of collaborators')
    };

    /**
     * Standard options for search TextField
     *
     * @constant
     */
    EditLabels.SEARCH_TEXT = { placeholder: gt('Search ...'), tooltip: gt('Find text'), smallerVersion: { css: { width: 110 } }, showClearButton: true };

    /**
     * Standard options for start search button
     *
     * @constant
     */
    EditLabels.SEARCH_START = { icon: 'fa-search', tooltip: gt('Start search') };

    /**
     * Standard options for search previous button
     *
     * @constant
     */
    EditLabels.SEARCH_PREV = { icon: 'fa-chevron-left', tooltip: gt('Select previous search result') };

    /**
     * Standard options for search next button
     *
     * @constant
     */
    EditLabels.SEARCH_NEXT = { icon: 'fa-chevron-right', tooltip: gt('Select next search result') };

    /**
     * Standard options for replace TextField
     *
     * @constant
     */
    EditLabels.REPLACE_TEXT = { placeholder: gt('Replace with ...'), tooltip: gt('Replacement text'), smallerVersion: { css: { width: 110 } }, showClearButton: true };

    /**
     * Standard options for replace next button
     *
     * @constant
     */
    EditLabels.REPLACE_NEXT = { label: /*#. in search/replace: button label */ gt('Replace'), tooltip: gt('Replace selected search result and select the next result'), smallerVersion: { css: { maxWidth: 50, textOverflow: 'ellipsis', overflow: 'hidden' } } };

    /**
     * Standard options for replace all button
     *
     * @constant
     */
    EditLabels.REPLACE_ALL = { label: /*#. in search/replace: replace all occurrences */ gt('Replace all'), tooltip: gt('Replace all search results'), smallerVersion: { css: { maxWidth: 50, textOverflow: 'ellipsis', overflow: 'hidden' } } };

    /**
     * Standard options for search tab entry
     *
     * @constant
     */
    EditLabels.TAB_SEARCH = { label: gt('Search'), icon: 'fa-search' };

    /**
     * Standard options for search & replace tab entry
     *
     * @constant
     */
    EditLabels.TAB_SEARCH_REPLACE = { label: gt('Replace'), icon: 'fa-search' };

    /**
     * @constant
     */
    EditLabels.NO_SEARCHRESULT_OPTIONS = {
        type: 'info',
        message: gt('No search result found.')
    };

    // exports ================================================================

    return EditLabels;

});
