/**
 * This work is provided under the terms of the CREATIVE COMMONS PUBLIC
 * LICENSE. This work is protected by copyright and/or other applicable
 * law. Any use of the work other than as authorized under this license
 * or copyright law is prohibited.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 * Copyright (C) 2016 OX Software GmbH
 * Mail: info@open-xchange.com
 *
 * @author Peter Seliger <peter.seliger@open-xchange.com>
 */

define('io.ox/office/editframework/utils/paragraphspacing', function () {

    'use strict';

    /**
     *  ParagraphSpacing module ================================================
     *
     *  values and methods beneath can not be added as static constants
     *  to 'io.ox/office/text/format/paragraphstyles' due to otherwise
     *  violating package dependency rules.
     */

    var
        ParagraphSpacing = {

            /**
             *  Predefined multiplier values for each effected paragraph's
             *  `marginBottom` attribute, in relation to a page's default
             *  paragraph settings.
             *  Supporting values and helper methods for computation as well.
             */
            setting: {
                multiplier: {
                    NONE:   0,
                    NORMAL: 1,
                    WIDE:   2
                },
                fallbackValue: {
                    NORMAL: 352
                },
                DECIMAL_PRECISION: 2
            }
        },

        DECIMAL_PRECISION = ParagraphSpacing.setting.DECIMAL_PRECISION,

        multiplierMap     = ParagraphSpacing.setting.multiplier,
        fallbackMap       = ParagraphSpacing.setting.fallbackValue,

        getDefaultMarginBottom = function get_default_margin_bottom(docModel) {
            var
                fallbackValue     = fallbackMap.NORMAL,
                defaultAttributes = docModel.getDefaultAttributes('paragraph');

            return (defaultAttributes.marginBottom || fallbackValue);
        },
        getPreciseMultiplier = function get_precise_multiplier(multiplier) {

            return parseFloat(multiplier.toFixed(DECIMAL_PRECISION));
        };

    Object.keys(multiplierMap).forEach(function (key) {

        this[key] = getPreciseMultiplier(this[key]);

    }, multiplierMap);

    ParagraphSpacing.helper = {
    //  getPreciseMultiplier: getPreciseMultiplier,

        computeMarginBottom: function compute_margin_bottom(multiplier, docModel) {

            return (multiplier * getDefaultMarginBottom(docModel));
        },
        // bug 46249:  margin top needs to be considered when 'Paragraph spacing' is set to none in our GUI
        getZeroSpaceMargin: function () {
            return 0;
        },
        computeMultiplier: function compute_multiplier(attributes, docModel) {
            var
                defaultMarginBottom = getDefaultMarginBottom(docModel),
                multiplier          = Math.round(attributes.marginBottom / defaultMarginBottom);

            return (_.isFinite(multiplier) ? getPreciseMultiplier(multiplier) : null);
        }
    };

    // exports ================================================================

    return ParagraphSpacing;
});
