/**
 * This work is provided under the terms of the CREATIVE COMMONS PUBLIC
 * LICENSE. This work is protected by copyright and/or other applicable
 * law. Any use of the work other than as authorized under this license
 * or copyright law is prohibited.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 * Copyright (C) 2016 OX Software GmbH
 * Mail: info@open-xchange.com
 *
 * @author Daniel Rentz <daniel.rentz@open-xchange.com>
 */

define('io.ox/office/editframework/utils/lineheight', function () {

    'use strict';

    // LineHeight module ================================================

    /**
     * Predefined values for the 'lineHeight' attribute for paragraphs.
     */
    var LineHeight = {
        NORMAL:   { type: 'normal' },
        SINGLE:   { type: 'percent', value: 100 },
        _115:     { type: 'percent', value: 115 },
        ONE_HALF: { type: 'percent', value: 150 },
        DOUBLE:   { type: 'percent', value: 200 }
    };

    // exports ================================================================

    return LineHeight;

});
